/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack;

import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.CloudProvider;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.types.Facing;
import org.openstack4j.core.transport.Config;
import org.openstack4j.core.transport.internal.HttpLoggingFilter;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.openstack.client.OSClientBuilder;
import org.openstack4j.openstack.internal.OSClientSession;

public abstract class OSFactory<T extends OSFactory<T>> {
    private OSFactory() {
    }

    public static OSClient.OSClientV3 clientFromToken(Token token) {
        return OSClientSession.OSClientSessionV3.createSession(token);
    }

    public static OSClient.OSClientV3 clientFromToken(Token token, Facing perspective) {
        return OSClientSession.OSClientSessionV3.createSession(token, perspective, null, null);
    }

    public static OSClient.OSClientV3 clientFromToken(Token token, Config config) {
        return OSClientSession.OSClientSessionV3.createSession(token, null, null, config);
    }

    public static OSClient.OSClientV3 clientFromToken(Token token, Facing perspective, Config config) {
        return OSClientSession.OSClientSessionV3.createSession(token, perspective, null, config);
    }

    public static OSClient.OSClientV3 clientFromToken(Token token, Facing perspective, CloudProvider provider, Config config) {
        return OSClientSession.OSClientSessionV3.createSession(token, perspective, provider, config);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access) {
        return OSClientSession.OSClientSessionV2.createSession(access);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access, Facing perspective) {
        return OSClientSession.OSClientSessionV2.createSession(access, perspective, null, null);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access, Config config) {
        return OSClientSession.OSClientSessionV2.createSession(access, null, null, config);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access, Facing perspective, Config config) {
        return OSClientSession.OSClientSessionV2.createSession(access, perspective, null, config);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access, Facing perspective, CloudProvider provider, Config config) {
        return OSClientSession.OSClientSessionV2.createSession(access, perspective, provider, config);
    }

    public static void enableHttpLoggingFilter(boolean enabled) {
        HttpLoggingFilter.toggleLogging(enabled);
    }

    public static IOSClientBuilder.V2 builderV2() {
        return new OSClientBuilder.ClientV2();
    }

    public static IOSClientBuilder.V3 builderV3() {
        return new OSClientBuilder.ClientV3();
    }
}

