/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.object.options;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ObjectListOptions {
    private Map<String, String> queryParams = new HashMap<String, String>();

    private ObjectListOptions() {
    }

    public static ObjectListOptions create() {
        return new ObjectListOptions();
    }

    public ObjectListOptions limit(int limit) {
        if (limit < 0) {
            throw new IllegalStateException("limit must be >= 0");
        }
        if (limit > 10000) {
            throw new IllegalStateException("limit must be <= 10000");
        }
        this.queryParams.put("limit", Integer.toString(limit));
        return this;
    }

    public ObjectListOptions marker(String marker) {
        this.queryParams.put("marker", Objects.requireNonNull(marker, "marker"));
        return this;
    }

    public ObjectListOptions endMarker(String endMarker) {
        this.queryParams.put("end_marker", Objects.requireNonNull(endMarker, "endMarker"));
        return this;
    }

    public ObjectListOptions startsWith(String prefix) {
        this.queryParams.put("prefix", Objects.requireNonNull(prefix, "prefix"));
        return this;
    }

    public ObjectListOptions delimiter(char delimiter) {
        this.queryParams.put("delimiter", Character.toString(delimiter));
        return this;
    }

    public ObjectListOptions path(String path) {
        this.queryParams.put("path", Objects.requireNonNull(path, "path"));
        return this;
    }

    public Map<String, String> getOptions() {
        return this.queryParams;
    }
}

