/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.object.options;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ContainerListOptions {
    private Map<String, String> queryParams = new HashMap<String, String>();

    private ContainerListOptions() {
    }

    public static ContainerListOptions create() {
        return new ContainerListOptions();
    }

    public ContainerListOptions startsWith(String prefix) {
        return this.add("prefix", Objects.requireNonNull(prefix));
    }

    public ContainerListOptions limit(int limit) {
        if (limit < 0) {
            throw new IllegalStateException("limit must be >= 0");
        }
        if (limit > 10000) {
            throw new IllegalStateException("limit must be <= 10000");
        }
        this.add("limit", Integer.toString(limit));
        return this;
    }

    public ContainerListOptions marker(String marker) {
        this.add("marker", Objects.requireNonNull(marker, "marker"));
        return this;
    }

    public ContainerListOptions endMarker(String endMarker) {
        this.add("end_marker", Objects.requireNonNull(endMarker, "endMarker"));
        return this;
    }

    public ContainerListOptions delimiter(char delimiter) {
        return this.add("delimiter", Character.toString(delimiter));
    }

    public ContainerListOptions path(String path) {
        return this.add("path", Objects.requireNonNull(path));
    }

    private ContainerListOptions add(String param, String value) {
        this.queryParams.put(param, value);
        return this;
    }

    public Map<String, String> getOptions() {
        return this.queryParams;
    }
}

