/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.block;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Date;
import java.util.Objects;
import org.openstack4j.model.ModelEntity;

public interface VolumeBackup
extends ModelEntity {
    public String getId();

    public String getName();

    public String getDescription();

    public String getVolumeId();

    public String getContainer();

    public Boolean isIncremental();

    public String getZone();

    public Status getStatus();

    public int getSize();

    public Date getCreated();

    public String getFailReason();

    public int getObjectCount();

    public Boolean hasDependent();

    public String getSnapshotId();

    public static enum Status {
        AVAILABLE,
        CREATING,
        DELETING,
        ERROR,
        ERROR_RESTORING,
        RESTORING,
        UNRECOGNIZED;


        @JsonCreator
        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Objects.requireNonNull(status, "migrationStatus").toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase().replace('_', '-');
        }

        public String toString() {
            return this.value();
        }
    }
}

