/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.block;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.storage.block.VolumeAttachment;
import org.openstack4j.model.storage.block.builder.VolumeBuilder;
import org.slf4j.LoggerFactory;

public interface Volume
extends ModelEntity,
Buildable<VolumeBuilder> {
    public String getId();

    public String getName();

    @Deprecated
    public String getDisplayName();

    public String getDescription();

    @Deprecated
    public String getDisplayDescription();

    public Status getStatus();

    public int getSize();

    public String getZone();

    public Date getCreated();

    public String getVolumeType();

    public String getSnapshotId();

    public String getImageRef();

    public Boolean multiattach();

    public String getSourceVolid();

    public Map<String, String> getMetaData();

    public List<? extends VolumeAttachment> getAttachments();

    public MigrationStatus getMigrateStatus();

    public String getTenantId();

    public boolean bootable();

    public boolean encrypted();

    public String host();

    public static enum MigrationStatus {
        MIGRATING,
        ERROR,
        SUCCESS,
        COMPLETING,
        NONE,
        STARTING;


        @JsonCreator
        public static MigrationStatus fromValue(String migrationStatus) {
            try {
                return MigrationStatus.valueOf(Objects.requireNonNull(migrationStatus, "migrationStatus").toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(MigrationStatus.class).error(e.getMessage(), (Throwable)e);
                return NONE;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase().replace('_', '-');
        }

        public String toString() {
            return this.value();
        }
    }

    public static enum Status {
        AVAILABLE,
        ATTACHING,
        BACKING_UP,
        CREATING,
        DELETING,
        DOWNLOADING,
        UPLOADING,
        ERROR,
        ERROR_DELETING,
        ERROR_RESTORING,
        IN_USE,
        RESTORING_BACKUP,
        DETACHING,
        UNRECOGNIZED,
        RESERVERD;


        @JsonCreator
        public static Status fromValue(String status) {
            try {
                return Status.valueOf(Objects.requireNonNull(status, "migrationStatus").toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase().replace('_', '-');
        }

        public String toString() {
            return this.value();
        }
    }
}

