/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.image.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Date;
import java.util.List;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.model.image.v2.ContainerFormat;
import org.openstack4j.model.image.v2.DiskFormat;
import org.openstack4j.model.image.v2.builder.ImageBuilder;
import org.openstack4j.openstack.image.v2.domain.GlanceImage;

public interface Image
extends BasicResource,
Buildable<ImageBuilder> {
    public ImageStatus getStatus();

    @Override
    public String getName();

    public List<String> getTags();

    public ContainerFormat getContainerFormat();

    public Date getCreatedAt();

    public DiskFormat getDiskFormat();

    public Date getUpdatedAt();

    public Long getMinDisk();

    public Boolean getIsProtected();

    @Override
    public String getId();

    public Long getMinRam();

    public String getChecksum();

    public String getOwner();

    public ImageVisibility getVisibility();

    public Long getSize();

    public List<GlanceImage.Location> getLocations();

    public String getDirectUrl();

    public String getSelf();

    public String getFile();

    public String getSchema();

    public String getRamdiskId();

    public String getOsDistro();

    public String getOsVersion();

    public String getKernelId();

    public String getInstanceUuid();

    public String getArchitecture();

    public Long getVirtualSize();

    public String getAdditionalPropertyValue(String var1);

    public static enum ImageVisibility {
        PUBLIC,
        PRIVATE,
        UNKNOWN;


        @JsonCreator
        public static ImageVisibility forValue(String value) {
            if (value != null) {
                for (ImageVisibility s : ImageVisibility.values()) {
                    if (!s.name().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return UNKNOWN;
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }

    public static enum ImageStatus {
        UNRECOGNIZED,
        QUEUED,
        SAVING,
        ACTIVE,
        DEACTIVATED,
        KILLED,
        DELETED,
        PENDING_DELETE;


        @JsonCreator
        public static ImageStatus value(String v) {
            if (v == null) {
                return UNRECOGNIZED;
            }
            try {
                return ImageStatus.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }
}

