/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.compute.actions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.compute.Personality;
import org.openstack4j.model.compute.actions.BaseActionOptions;

public final class RebuildOptions
extends BaseActionOptions {
    private RebuildOptions() {
    }

    public static RebuildOptions create() {
        return new RebuildOptions();
    }

    public RebuildOptions image(String imageId) {
        this.add(Option.IMAGE, imageId);
        return this;
    }

    public RebuildOptions name(String name) {
        this.add(Option.NAME, name);
        return this;
    }

    public RebuildOptions userData(String userData) {
        this.add(Option.USER_DATA, userData);
        return this;
    }

    public RebuildOptions personality(List<Personality> personality) {
        this.add(Option.PERSONALITY, personality);
        return this;
    }

    public RebuildOptions metadata(Map<String, String> metadata) {
        this.add(Option.METADATA, metadata);
        return this;
    }

    public RebuildOptions adminPass(String adminPass) {
        this.add(Option.ADMIN_PASS, adminPass);
        return this;
    }

    public String getName() {
        return (String)this.get(Option.NAME);
    }

    public String getAdminPass() {
        return (String)this.get(Option.ADMIN_PASS);
    }

    public String getImageRef() {
        return (String)this.get(Option.IMAGE);
    }

    @JsonProperty(value="user_data")
    public String getUserData() {
        return (String)this.get(Option.USER_DATA);
    }

    public List<Personality> getPersonality() {
        return (List)this.get(Option.PERSONALITY);
    }

    public Map<String, String> getMetadata() {
        return (Map)this.get(Option.METADATA);
    }

    private static enum Option implements BaseActionOptions.OptionEnum
    {
        IMAGE("imageRef"),
        NAME("name"),
        ADMIN_PASS("adminPass"),
        USER_DATA("user_data"),
        PERSONALITY("personality"),
        METADATA("metadata");

        private final String param;

        private Option(String param) {
            this.param = param;
        }

        @Override
        public String getParam() {
            return this.param;
        }
    }
}

