/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.compute;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openstack4j.model.ModelEntity;

public interface VNCConsole
extends ModelEntity {
    public Type getType();

    public String getURL();

    public static enum Type {
        NOVNC("novnc"),
        XVPVNC("xvpvnc"),
        SPICE("spice-html5"),
        UNRECOGNIZED("unregonized");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Type value(String vncType) {
            if (vncType == null || vncType.isEmpty()) {
                return UNRECOGNIZED;
            }
            try {
                for (Type t : Type.values()) {
                    if (!t.value.equalsIgnoreCase(vncType)) continue;
                    return t;
                }
                return UNRECOGNIZED;
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.value;
        }
    }
}

