/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.core.transport;

import java.util.function.Function;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.PropagateResponse;

public class ExecutionOptions<R> {
    private Function<HttpResponse, R> parser;
    private PropagateResponse propagateResponse;

    private ExecutionOptions(Function<HttpResponse, R> parser, PropagateResponse propagateResponse) {
        this.parser = parser;
        this.propagateResponse = propagateResponse;
    }

    public static <R> ExecutionOptions<R> create(Function<HttpResponse, R> parser) {
        return new ExecutionOptions<R>(parser, null);
    }

    public static <R> ExecutionOptions<R> create(PropagateResponse propagateResponse) {
        return new ExecutionOptions<R>(null, propagateResponse);
    }

    public static <R> ExecutionOptions<R> create(Function<HttpResponse, R> parser, PropagateResponse propagateResponse) {
        return new ExecutionOptions<R>(parser, propagateResponse);
    }

    public Function<HttpResponse, R> getParser() {
        return this.parser;
    }

    public boolean hasParser() {
        return this.parser != null;
    }

    public void propagate(HttpResponse response) {
        if (this.propagateResponse != null) {
            this.propagateResponse.propagate(response);
        }
    }
}

