/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.api;

import java.util.Map;
import java.util.Set;
import org.openstack4j.api.artifact.ArtifactService;
import org.openstack4j.api.barbican.BarbicanService;
import org.openstack4j.api.compute.ComputeService;
import org.openstack4j.api.dns.v2.DNSService;
import org.openstack4j.api.gbp.GbpService;
import org.openstack4j.api.heat.HeatService;
import org.openstack4j.api.identity.v2.IdentityService;
import org.openstack4j.api.image.ImageService;
import org.openstack4j.api.magnum.MagnumService;
import org.openstack4j.api.manila.ShareService;
import org.openstack4j.api.murano.v1.AppCatalogService;
import org.openstack4j.api.networking.NetworkingService;
import org.openstack4j.api.networking.ext.ServiceFunctionChainService;
import org.openstack4j.api.octavia.OctaviaService;
import org.openstack4j.api.placement.PlacementService;
import org.openstack4j.api.sahara.SaharaService;
import org.openstack4j.api.senlin.SenlinService;
import org.openstack4j.api.storage.BlockStorageService;
import org.openstack4j.api.storage.ObjectStorageService;
import org.openstack4j.api.tacker.TackerService;
import org.openstack4j.api.telemetry.TelemetryService;
import org.openstack4j.api.trove.TroveService;
import org.openstack4j.api.types.Facing;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.api.workflow.WorkflowService;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v3.Token;

public interface OSClient<T extends OSClient<T>> {
    public T useRegion(String var1);

    public T removeRegion();

    public T perspective(Facing var1);

    public T headers(Map<String, String> var1);

    public Set<ServiceType> getSupportedServices();

    public boolean supportsCompute();

    public boolean supportsIdentity();

    public boolean supportsNetwork();

    public boolean supportsImage();

    public boolean supportsHeat();

    public boolean supportsMurano();

    public boolean supportsBlockStorage();

    public boolean supportsObjectStorage();

    public boolean supportsTelemetry();

    public boolean supportsShare();

    public String getEndpoint();

    public ComputeService compute();

    public NetworkingService networking();

    public PlacementService placement();

    public ServiceFunctionChainService sfc();

    public OctaviaService octavia();

    public ArtifactService artifact();

    public TackerService tacker();

    public BlockStorageService blockStorage();

    public ObjectStorageService objectStorage();

    public ImageService images();

    public org.openstack4j.api.image.v2.ImageService imagesV2();

    public TelemetryService telemetry();

    public ShareService share();

    public HeatService heat();

    public AppCatalogService murano();

    public SaharaService sahara();

    public WorkflowService workflow();

    public MagnumService magnum();

    public GbpService gbp();

    public SenlinService senlin();

    public TroveService trove();

    public BarbicanService barbican();

    public DNSService dns();

    public static interface OSClientV3
    extends OSClient<OSClientV3> {
        public Token getToken();

        public org.openstack4j.api.identity.v3.IdentityService identity();
    }

    public static interface OSClientV2
    extends OSClient<OSClientV2> {
        public Access getAccess();

        public IdentityService identity();
    }
}

