/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import hudson.EnvVars;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftOAuth2SecurityRealm;

public class OpenShiftSetOAuth {
    static final Logger LOGGER = Logger.getLogger(OpenShiftSetOAuth.class.getName());
    static final String OPENSHIFT_ENABLE_OAUTH = "OPENSHIFT_ENABLE_OAUTH";
    static long lastCheck = 0L;
    static int lastLog = 0;

    static boolean setOauth() {
        return OpenShiftSetOAuth.setOauth(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setOauth(boolean force) {
        Jenkins jenkins = Jenkins.getInstance();
        String enabled = (String)EnvVars.masterEnvVars.get(OPENSHIFT_ENABLE_OAUTH);
        if (jenkins != null && enabled != null && !enabled.equalsIgnoreCase("false")) {
            SecurityRealm priorSecurityRealm = jenkins.getSecurityRealm();
            if (!(priorSecurityRealm instanceof OpenShiftOAuth2SecurityRealm)) {
                Class<OpenShiftSetOAuth> clazz = OpenShiftSetOAuth.class;
                synchronized (OpenShiftSetOAuth.class) {
                    if (force || System.currentTimeMillis() > lastCheck + 1000L) {
                        LOGGER.info("OpenShift OAuth: enable oauth set to " + enabled + " force " + force + " lastCheck " + String.valueOf(new Date(lastCheck)));
                        LOGGER.info("OpenShift OAuth: configured security realm on startup: " + String.valueOf(priorSecurityRealm) + " last check " + String.valueOf(new Date(lastCheck)));
                        lastCheck = System.currentTimeMillis();
                        try {
                            OpenShiftOAuth2SecurityRealm osrealm = new OpenShiftOAuth2SecurityRealm(null, null, null, null, null, null);
                            boolean inOpenShiftPod = false;
                            try {
                                inOpenShiftPod = osrealm.populateDefaults();
                            }
                            catch (Throwable t) {
                                if (lastLog % 100 == 0) {
                                    LOGGER.log(Level.SEVERE, "OpenShiftSetOAuth", t);
                                }
                                ++lastLog;
                            }
                            LOGGER.info("OpenShift OAuth: running in OpenShift pod with required OAuth features: " + inOpenShiftPod);
                            if (inOpenShiftPod) {
                                jenkins.setSecurityRealm((SecurityRealm)osrealm);
                                LOGGER.info("OpenShift OAuth: Jenkins security realm set to OpenShift OAuth");
                                // ** MonitorExit[var4_4] (shouldn't be in output)
                                return true;
                            }
                        }
                        catch (IOException e1) {
                            if (lastLog % 100 == 0) {
                                LOGGER.log(Level.SEVERE, "OpenShiftSetOAuth", e1);
                            }
                            ++lastLog;
                        }
                        catch (GeneralSecurityException e1) {
                            if (lastLog % 100 == 0) {
                                LOGGER.log(Level.SEVERE, "OpenShiftSetOAuth", e1);
                            }
                            ++lastLog;
                        }
                        catch (Throwable t) {
                            if (lastLog % 100 == 0) {
                                LOGGER.log(Level.SEVERE, "OpenShiftSetOAuth", t);
                            }
                            ++lastLog;
                        }
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                }
            }
            OpenShiftOAuth2SecurityRealm secRealm = (OpenShiftOAuth2SecurityRealm)priorSecurityRealm;
            secRealm.createFilter();
        }
        return false;
    }
}

