/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid.impl;

import com.cloudbees.openid4java.team.TeamExtensionFactory;
import com.cloudbees.openid4java.team.TeamExtensionRequest;
import com.cloudbees.openid4java.team.TeamExtensionResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.plugins.openid.Identity;
import hudson.plugins.openid.OpenIdExtension;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;

@Extension
public class TeamsExtension
extends OpenIdExtension {
    private static final Logger LOGGER;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Common Jenkins pattern for configs, which may be changed in the runtime")
    public static boolean DISABLE;

    @Override
    public void extend(AuthRequest authRequest) throws MessageException {
        if (DISABLE) {
            return;
        }
        TeamExtensionRequest req = new TeamExtensionRequest();
        Collection groups = Jenkins.get().getAuthorizationStrategy().getGroups();
        req.setQueryMembership(groups);
        authRequest.addExtension((MessageExtension)req);
        LOGGER.log(Level.FINE, "Checking memberships of {0} with OpenID", new ArrayList(groups));
    }

    @Override
    public void process(AuthSuccess authSuccess, Identity id) throws MessageException {
        if (DISABLE) {
            return;
        }
        TeamExtensionResponse ter = this.getMessageAs(TeamExtensionResponse.class, authSuccess, "http://ns.launchpad.net/2007/openid-teams");
        List<GrantedAuthority> r = id.getGrantedAuthorities();
        for (String s : ter.getTeamMembership()) {
            r.add((GrantedAuthority)new GrantedAuthorityImpl(s));
        }
        r.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        LOGGER.log(Level.FINE, "Adding {0} as authorities from team extension to {1}", new Object[]{ter.getTeamMembership(), id.getOpenId()});
    }

    static {
        TeamExtensionFactory.install();
        LOGGER = Logger.getLogger(TeamsExtension.class.getName());
        DISABLE = Boolean.parseBoolean(System.getProperty(TeamsExtension.class.getName() + ".disable", System.getProperty(TeamsExtension.class.getName() + "disable")));
    }
}

