/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.node.Node;
import java.util.LinkedList;

public class SelectionNode<T>
extends Node<T> {
    private final Expression<T> test;

    public SelectionNode(Adapter<T> runtime, Expression<T> test) {
        super(runtime);
        this.test = test;
    }

    @Override
    public T search(T input) {
        if (this.runtime.typeOf(input) == JmesPathType.ARRAY) {
            LinkedList<T> selectedElements = new LinkedList<T>();
            for (T element : this.runtime.toList(input)) {
                T testResult = this.test.search(element);
                if (!this.runtime.isTruthy(testResult)) continue;
                selectedElements.add(element);
            }
            return (T)this.runtime.createArray(selectedElements);
        }
        return this.runtime.createNull();
    }

    @Override
    protected String internalToString() {
        return this.test.toString();
    }

    @Override
    protected boolean internalEquals(Object o) {
        SelectionNode other = (SelectionNode)o;
        return this.test.equals(other.test);
    }

    @Override
    protected int internalHashCode() {
        return this.test.hashCode();
    }
}

