/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.http.adapter;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.WithContentAction;
import org.pac4j.core.exception.http.WithLocationAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.jee.context.JEEContext;

public class JEEHttpActionAdapter
implements HttpActionAdapter {
    public static final HttpActionAdapter INSTANCE = new JEEHttpActionAdapter();

    protected JEEHttpActionAdapter() {
    }

    public Object adapt(HttpAction action, WebContext context) {
        if (action != null) {
            WithContentAction withContentAction;
            String content;
            int code = action.getCode();
            JEEContext jeeContext = (JEEContext)context;
            HttpServletResponse response = jeeContext.getNativeResponse();
            if (code < 400) {
                response.setStatus(code);
            } else {
                String savedAuthHeader = jeeContext.getSavedAuthenticateHeader();
                if (savedAuthHeader != null) {
                    response.setHeader("WWW-Authenticate", savedAuthHeader);
                }
                try {
                    response.sendError(code);
                }
                catch (IOException e) {
                    throw new TechnicalException((Throwable)e);
                }
            }
            if (action instanceof WithLocationAction) {
                WithLocationAction withLocationAction = (WithLocationAction)action;
                context.setResponseHeader("Location", withLocationAction.getLocation());
            } else if (action instanceof WithContentAction && (content = (withContentAction = (WithContentAction)action).getContent()) != null) {
                try {
                    response.getWriter().write(content);
                }
                catch (IOException e) {
                    throw new TechnicalException((Throwable)e);
                }
            }
            return null;
        }
        throw new TechnicalException("No action provided");
    }
}

