/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReverseFunction
extends BaseFunction {
    public ReverseFunction() {
        super(ArgumentConstraints.typeOf(JmesPathType.ARRAY, JmesPathType.STRING));
    }

    @Override
    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        T subject = arguments.get(0).value();
        JmesPathType subjectType = runtime.typeOf(subject);
        if (subjectType == JmesPathType.ARRAY) {
            ArrayList<T> elements = new ArrayList<T>(runtime.toList(subject));
            Collections.reverse(elements);
            return runtime.createArray(elements);
        }
        return runtime.createString(new StringBuilder(runtime.toString(subject)).reverse().toString());
    }
}

