/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic.properties;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.security.FIPS140;
import org.apache.commons.lang.Validate;
import org.jenkinsci.plugins.oic.AnythingGoesTokenValidator;
import org.jenkinsci.plugins.oic.OicServerConfiguration;
import org.jenkinsci.plugins.oic.OidcProperty;
import org.jenkinsci.plugins.oic.OidcPropertyDescriptor;
import org.jenkinsci.plugins.oic.OidcPropertyExecution;
import org.jenkinsci.plugins.oic.properties.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.metadata.OidcOpMetadataResolver;
import org.pac4j.oidc.metadata.StaticOidcOpMetadataResolver;
import org.pac4j.oidc.profile.creator.TokenValidator;

public class DisableTokenVerification
extends OidcProperty {
    @DataBoundConstructor
    public DisableTokenVerification() {
        Validate.isTrue((!FIPS140.useCompliantAlgorithms() ? 1 : 0) != 0, (String)"Token verification can not be disabled");
    }

    @Override
    @NonNull
    public OidcPropertyExecution newExecution(@NonNull OicServerConfiguration serverConfiguration) {
        return new ExecutionImpl(serverConfiguration);
    }

    private record ExecutionImpl(OicServerConfiguration serverConfiguration) implements OidcPropertyExecution
    {
        @Override
        public void customizeConfiguration(@NonNull OidcConfiguration configuration) {
            configuration.setAllowUnsignedIdTokens(true);
            StaticOidcOpMetadataResolver opMetadataResolver = new StaticOidcOpMetadataResolver(configuration, this.serverConfiguration.toProviderMetadata()){

                protected TokenValidator createTokenValidator() {
                    return new AnythingGoesTokenValidator();
                }
            };
            configuration.setOpMetadataResolver((OidcOpMetadataResolver)opMetadataResolver);
            opMetadataResolver.init();
        }

        @Override
        public void customizeClient(@NonNull OidcClient client) {
            OidcPropertyExecution.super.customizeClient(client);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends OidcPropertyDescriptor {
        @Override
        public boolean isApplicable() {
            return !FIPS140.useCompliantAlgorithms();
        }

        @Override
        public void getFallbackConfiguration(@NonNull OicServerConfiguration serverConfiguration, @NonNull OidcConfiguration configuration) {
            StaticOidcOpMetadataResolver opMetadataResolver = new StaticOidcOpMetadataResolver(configuration, serverConfiguration.toProviderMetadata());
            configuration.setOpMetadataResolver((OidcOpMetadataResolver)opMetadataResolver);
            opMetadataResolver.init();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.DisableTokenVerification_DisplayName();
        }
    }
}

