/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf.credentials;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import hudson.model.Item;
import hudson.security.ACL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.octoperf.OctoperfCredential;
import org.jenkinsci.plugins.octoperf.credentials.CredentialsService;

final class JenkinsCredentialsService
implements CredentialsService {
    private static final List<DomainRequirement> NO_REQUIREMENTS = ImmutableList.of();
    private static final String DEFAULT_SCOPE = "Global";

    JenkinsCredentialsService() {
    }

    @Override
    public Optional<OctoperfCredential> findFirst(@Nullable Item item) {
        Iterator<OctoperfCredential> iterator = this.getCredentials(DEFAULT_SCOPE, item).iterator();
        if (iterator.hasNext()) {
            OctoperfCredential c = iterator.next();
            return Optional.of(c);
        }
        return Optional.empty();
    }

    @Override
    public Optional<OctoperfCredential> find(String id, @Nullable Item item) {
        for (OctoperfCredential c : this.getCredentials(DEFAULT_SCOPE, item)) {
            if (!Objects.equal((Object)c.getId(), (Object)id)) continue;
            return Optional.of(c);
        }
        return Optional.empty();
    }

    @Override
    public List<OctoperfCredential> getCredentials(Object scope, @Nullable Item item) {
        ArrayList<OctoperfCredential> result = new ArrayList<OctoperfCredential>();
        HashSet<String> ids = new HashSet<String>();
        for (OctoperfCredential c : CredentialsProvider.lookupCredentials(OctoperfCredential.class, (Item)item, (Authentication)ACL.SYSTEM, NO_REQUIREMENTS)) {
            String id = c.getId();
            if (ids.contains(id)) continue;
            result.add(c);
            ids.add(id);
        }
        return result;
    }
}

