/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.octoperf;

import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.octoperf.OctoPerfBuild;
import org.jenkinsci.plugins.octoperf.OctoperfBuilderDescriptor;
import org.jenkinsci.plugins.octoperf.OctoperfCredential;
import org.jenkinsci.plugins.octoperf.conditions.TestStopCondition;
import org.jenkinsci.plugins.octoperf.credentials.CredentialsService;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OctoperfBuilder
extends Builder
implements SimpleBuildStep {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"HH:mm:ss");
    public static final long TEN_SECS = 10000L;
    private String credentialsId = "";
    private String workspaceId = "";
    private String projectId = "";
    private String scenarioId = "";
    private String serverUrl = "";
    private String testName = "";
    private List<? extends TestStopCondition> stopConditions = new ArrayList<TestStopCondition>();

    @DataBoundConstructor
    public OctoperfBuilder(String credentialsId, String workspaceId, String projectId, String scenarioId, String testName, List<? extends TestStopCondition> stopConditions) {
        this.setCredentialsId(credentialsId);
        this.setWorkspaceId(workspaceId);
        this.setProjectId(projectId);
        this.setScenarioId(scenarioId);
        this.setStopConditions(stopConditions);
        this.setTestName(testName);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public List<? extends TestStopCondition> getStopConditions() {
        return this.stopConditions;
    }

    @DataBoundSetter
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = Strings.nullToEmpty((String)workspaceId);
    }

    @DataBoundSetter
    public void setProjectId(String projectId) {
        this.projectId = Strings.nullToEmpty((String)projectId);
    }

    @DataBoundSetter
    public void setScenarioId(String scenarioId) {
        this.scenarioId = Strings.nullToEmpty((String)scenarioId);
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Strings.nullToEmpty((String)credentialsId);
    }

    @DataBoundSetter
    public void setStopConditions(List<? extends TestStopCondition> stopConditions) {
        this.stopConditions = Optional.ofNullable(stopConditions).orElse(new ArrayList());
    }

    @DataBoundSetter
    public void setTestName(String testName) {
        this.testName = Strings.nullToEmpty((String)testName);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) {
        this.perform(run, workspace, listener, new EnvVars());
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @Nonnull EnvVars vars) {
        Result result;
        String serverUrlConfig = OctoperfBuilderDescriptor.getDescriptor().getOctoperfURL();
        Optional<OctoperfCredential> credentials = CredentialsService.CREDENTIALS_SERVICE.find(this.credentialsId, (Item)run.getParent());
        OctoPerfBuild build = new OctoPerfBuild(listener.getLogger(), credentials.map(UsernameCredentials::getUsername).orElse(""), credentials.map(PasswordCredentials::getPassword).orElse(null), this.scenarioId, Optional.ofNullable(this.testName), (List<? extends TestStopCondition>)ImmutableList.copyOf(this.stopConditions), workspace, serverUrlConfig != null ? serverUrlConfig : this.serverUrl, vars);
        try {
            result = (Result)build.call();
        }
        catch (Exception e) {
            result = Result.FAILURE;
            listener.fatalError("Error while running test: " + String.valueOf(e));
        }
        run.setResult(result);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }
}

