/*
 * Decompiled with CFR 0.152.
 */
package com.nowsecure.plugin;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.nowsecure.models.AnalysisType;
import com.nowsecure.models.LogLevel;
import com.nowsecure.models.NowSecureBinary;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class NowSecurePlugin
extends Builder
implements SimpleBuildStep {
    private final String binaryFilePath;
    private final String group;
    private final String tokenCredentialId;
    private String artifactDir;
    private String apiHost;
    private String uiHost;
    private String nowsecureCIVersion;
    private LogLevel logLevel = LogLevel.INFO;
    private AnalysisType analysisType = AnalysisType.STATIC;
    private int minimumScore;
    private int pollingDurationMinutes;

    @DataBoundConstructor
    public NowSecurePlugin(String binaryFilePath, String group, String tokenCredentialId) {
        this.binaryFilePath = Util.fixEmptyAndTrim((String)binaryFilePath);
        this.group = Util.fixEmptyAndTrim((String)group);
        this.tokenCredentialId = Util.fixEmptyAndTrim((String)tokenCredentialId);
    }

    private Optional<StringCredentials> getCredentials(String credentialsId) {
        return CredentialsMatchers.filter((List)CredentialsProvider.lookupCredentialsInItemGroup(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)).stream().findFirst();
    }

    private Map<String, String> getProxyEnvVars(ProxyConfiguration configuration) {
        if (configuration == null) {
            return Map.of();
        }
        String host = configuration.getName();
        int port = configuration.getPort();
        String user = configuration.getUserName();
        String pass = Secret.toString((Secret)configuration.getSecretPassword());
        String authentication = StringUtils.isEmpty((CharSequence)user) && StringUtils.isEmpty((CharSequence)pass) ? "" : String.format("%s:%s@", user, pass);
        String httpProxy = String.format("http://%s%s:%d", authentication, host, port);
        return Map.of("HTTP_PROXY", httpProxy, "HTTPS_PROXY", httpProxy, "NO_PROXY", configuration.getNoProxyHost());
    }

    public String getStringProperty(Computer computer, String propName) throws AbortException, InterruptedException, IOException {
        Object v;
        Map properties = computer.getSystemProperties();
        if (properties != null && (v = properties.get(propName)) instanceof String) {
            String str = (String)v;
            return str;
        }
        throw new AbortException(String.format("Unexpected type for system property '%s'", propName));
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Computer worker = workspace.toComputer();
        if (worker == null) {
            throw new AbortException("Workspace not a file on a particular Computer");
        }
        String arch = this.getStringProperty(worker, "os.arch");
        String osName = this.getStringProperty(worker, "os.name");
        FilePath binaryFile = workspace.child(this.binaryFilePath);
        Optional<StringCredentials> optionalCredentials = this.getCredentials(this.tokenCredentialId);
        if (!binaryFile.exists()) {
            String errorMessage = String.format("Cannot find binary file at path: %s", binaryFile.toURI());
            listener.error(errorMessage);
            throw new AbortException(errorMessage);
        }
        if (optionalCredentials.isEmpty()) {
            String errorMessage = "Could not find a TextCredential matching the specified credentialId";
            listener.error(errorMessage);
            throw new AbortException(errorMessage);
        }
        StringCredentials credential = optionalCredentials.get();
        CredentialsProvider.track(run, (Credentials)credential);
        String token = credential.getSecret().getPlainText();
        NowSecureBinary tool = new NowSecureBinary(arch, osName, workspace).addEnvVars(this.getProxyEnvVars(Jenkins.get().getProxy())).addArgument("run").addArgument("file", binaryFile.getRemote()).addArgument("--group-ref", this.group).addArgument("--api-host", this.apiHost).addArgument("--ui-host", this.uiHost).addArgument("--log-level", this.logLevel.toString().toLowerCase()).addArgument("--analysis-type", this.analysisType.toString().toLowerCase()).addArgument("--save-findings").addArgument("--artifacts-dir", this.artifactDir).addArgument("--output", String.format("%s%sassessment.json", this.artifactDir, File.separator)).addArgument("--minimum-score", String.valueOf(this.minimumScore)).addArgument("--poll-for-minutes", String.valueOf(this.pollingDurationMinutes)).addArgument("--ci-environment", "jenkins").addToken(token);
        int exitCode = tool.startProc(launcher, listener).join();
        if (exitCode != 0) {
            listener.getLogger().println("Exit Code: " + exitCode);
            throw new AbortException("NowSecure binary finished with nonzero exit code");
        }
    }

    @DataBoundSetter
    public void setAnalysisType(AnalysisType analysisType) {
        this.analysisType = analysisType;
    }

    @DataBoundSetter
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @DataBoundSetter
    public void setArtifactDir(String artifactDir) {
        String fixed = Util.fixEmptyAndTrim((String)artifactDir);
        if (fixed != null) {
            this.artifactDir = fixed;
        }
    }

    @DataBoundSetter
    public void setApiHost(String apiHost) {
        String fixed = Util.fixEmptyAndTrim((String)apiHost);
        if (fixed != null) {
            this.apiHost = fixed;
        }
    }

    @DataBoundSetter
    public void setUiHost(String uiHost) {
        String fixed = Util.fixEmptyAndTrim((String)uiHost);
        if (fixed != null) {
            this.uiHost = fixed;
        }
    }

    @DataBoundSetter
    public void setNowsecureCIVersion(String nowsecureCIVersion) {
        this.nowsecureCIVersion = nowsecureCIVersion;
    }

    @DataBoundSetter
    public void setMinimumScore(int minimumScore) {
        this.minimumScore = minimumScore;
    }

    @DataBoundSetter
    public void setPollingDurationMinutes(int pollingDurationMinutes) {
        this.pollingDurationMinutes = pollingDurationMinutes;
    }

    public String getBinaryFilePath() {
        return this.binaryFilePath;
    }

    public String getGroup() {
        return this.group;
    }

    public String getTokenCredentialId() {
        return this.tokenCredentialId;
    }

    public String getArtifactDir() {
        return this.artifactDir;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public String getUiHost() {
        return this.uiHost;
    }

    public String getNowsecureCIVersion() {
        return this.nowsecureCIVersion;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public int getMinimumScore() {
        return this.minimumScore;
    }

    public int getPollingDurationMinutes() {
        return this.pollingDurationMinutes;
    }

    @Symbol(value={"nowsecureAssessment"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "NowSecure Assessment Configuration";
        }

        @POST
        public FormValidation doCheckBinaryFile(@QueryParameter String binaryFile) {
            if (StringUtils.isBlank((CharSequence)binaryFile)) {
                return FormValidation.error((String)"Target Filename cannot be empty.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckGroup(@QueryParameter String group) {
            if (StringUtils.isBlank((CharSequence)group)) {
                return FormValidation.error((String)"Group Ref cannot be empty.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckTokenCredentialItems(@QueryParameter String tokenCredentialId) {
            if (StringUtils.isBlank((CharSequence)tokenCredentialId)) {
                return FormValidation.error((String)"Token Credential cannot be empty");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckApiHost(@QueryParameter String apiHost) {
            if (!StringUtils.isBlank((CharSequence)apiHost)) {
                try {
                    new URI(apiHost).toURL();
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Cannot be converted to a valid URL");
                }
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUiHost(@QueryParameter String uiHost) {
            if (!StringUtils.isBlank((CharSequence)uiHost)) {
                try {
                    new URI(uiHost).toURL();
                }
                catch (Exception e) {
                    return FormValidation.error((String)"Cannot be converted to a valid URL");
                }
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillTokenCredentialIdItems(@AncestorInPath Item item, @QueryParameter String tokenCredentialId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ)) {
                return result.includeCurrentValue(tokenCredentialId);
            }
            return result.includeMatchingAs(ACL.SYSTEM2, (ItemGroup)Jenkins.get(), StandardCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(tokenCredentialId);
        }
    }
}

