/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class BouncyCastleTrustStrategy
implements TrustStrategy {
    public static final TrustSelfSignedStrategy INSTANCE = new TrustSelfSignedStrategy();
    private final String preDefineCert;

    public BouncyCastleTrustStrategy(String userCert) {
        this.preDefineCert = userCert;
    }

    private String normalizeTheCert(String cert) {
        String removePattern = "[\n\\s]+";
        return cert.replaceAll(removePattern, "");
    }

    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Certificate chain is null or empty");
        }
        if (chain.length > 1) {
            throw new IllegalArgumentException("Certificate chain should be length one");
        }
        X509Certificate cert = chain[0];
        cert.checkValidity();
        StringWriter sw = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)sw);
        try {
            pemWriter.writeObject((Object)cert);
            pemWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String certFromServer = sw.toString();
        return this.normalizeTheCert(this.preDefineCert).equals(this.normalizeTheCert(certFromServer));
    }
}

