/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.FloatMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class FloatArrayMorpher
extends AbstractArrayMorpher {
    private static final Class FLOAT_ARRAY_CLASS = float[].class;
    private float defaultValue;

    public FloatArrayMorpher() {
        super(false);
    }

    public FloatArrayMorpher(float defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatArrayMorpher)) {
            return false;
        }
        FloatArrayMorpher other = (FloatArrayMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append(this.getDefaultValue(), other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isUseDefault()) {
            builder.append(this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (FLOAT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (float[])array;
        }
        if (array.getClass().isArray()) {
            FloatMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Float.TYPE, dimensions);
            FloatMorpher floatMorpher = morpher = this.isUseDefault() ? new FloatMorpher(this.defaultValue) : new FloatMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, new Float(morpher.morph(Array.get(array, index))));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class morphsTo() {
        return FLOAT_ARRAY_CLASS;
    }
}

