/*
 * Decompiled with CFR 0.152.
 */
package com.netsparker.cloud.model;

import com.netsparker.cloud.model.ProxyBlock;
import com.netsparker.cloud.utility.AppCommon;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.HttpHost;

public abstract class ScanRequestBase {
    protected static final String json = "application/json";
    public final URL ApiURL;
    public final Secret ApiToken;
    public final ProxyBlock proxy;

    public ScanRequestBase(String apiURL, Secret apiToken, ProxyBlock proxy) throws MalformedURLException {
        this.ApiURL = AppCommon.getBaseURL(apiURL);
        this.ApiToken = apiToken;
        this.proxy = proxy;
    }

    public ScanRequestBase() {
        this.ApiURL = null;
        this.ApiToken = null;
        this.proxy = null;
    }

    protected CloseableHttpClient getHttpClient() {
        if (this.proxy != null && this.proxy.getUseProxy().booleanValue()) {
            int proxyPort = Integer.parseInt(this.proxy.getpPort());
            HttpHost proxyHttpHost = new HttpHost(this.proxy.getpHost(), proxyPort);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            AuthScope authScope = new AuthScope(proxyHttpHost);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.proxy.getpUser(), this.proxy.getpPassword().toCharArray());
            credsProvider.setCredentials(authScope, (Credentials)credentials);
            return HttpClientBuilder.create().setProxy(proxyHttpHost).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).disableRedirectHandling().build();
        }
        return HttpClientBuilder.create().disableRedirectHandling().build();
    }

    protected String getAuthHeader() {
        String auth = ":" + this.ApiToken.getPlainText();
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
        String authHeader = "Basic " + new String(encodedAuth, StandardCharsets.ISO_8859_1);
        return authHeader;
    }
}

