/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.multibranchfilter;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.TaskListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.api.trait.SCMHeadFilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InactiveBranchFilterTrait
extends SCMSourceTrait {
    private static final Logger LOGGER = Logger.getLogger(InactiveBranchFilterTrait.class.getName());
    private static final String SPLIT_REGEX = "[\\r\\n]+";
    private static final String DEFAULT_ALLOWLIST = "master\nmain";
    private static volatile boolean sourceFieldInitialized;
    private static volatile Field sourceField;
    private final int inactivityDays;
    private String allowlist;
    private String denylist;

    @DataBoundConstructor
    public InactiveBranchFilterTrait(int inactivityDays) {
        this.inactivityDays = Math.max(0, inactivityDays);
        this.allowlist = DEFAULT_ALLOWLIST;
        this.denylist = "";
    }

    public int getInactivityDays() {
        return this.inactivityDays;
    }

    public String getAllowlist() {
        return InactiveBranchFilterTrait.normalizeList(this.allowlist);
    }

    public String getDenylist() {
        return InactiveBranchFilterTrait.normalizeList(this.denylist);
    }

    @DataBoundSetter
    public void setAllowlist(@Nullable String allowlist) {
        this.allowlist = InactiveBranchFilterTrait.normalizeList(allowlist);
    }

    @DataBoundSetter
    public void setDenylist(@Nullable String denylist) {
        this.denylist = InactiveBranchFilterTrait.normalizeList(denylist);
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        final List<Pattern> allowlistPatterns = InactiveBranchFilterTrait.parsePatternList(this.getAllowlist());
        final List<Pattern> denylistPatterns = InactiveBranchFilterTrait.parsePatternList(this.getDenylist());
        final int inactivityDays = this.inactivityDays;
        context.withFilter(new SCMHeadFilter(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean isExcluded(SCMSourceRequest request, SCMHead head) throws IOException, InterruptedException {
                TaskListener listener = request.listener();
                String name = head.getName();
                if (InactiveBranchFilterTrait.matchesAny(name, denylistPatterns)) {
                    InactiveBranchFilterTrait.logDecision(listener, name, true, "deny-list");
                    return true;
                }
                if (InactiveBranchFilterTrait.matchesAny(name, allowlistPatterns)) {
                    InactiveBranchFilterTrait.logDecision(listener, name, false, "allow-list");
                    return false;
                }
                if (head instanceof ChangeRequestSCMHead || head instanceof TagSCMHead) {
                    InactiveBranchFilterTrait.logDecision(listener, name, false, "change-request-or-tag");
                    return false;
                }
                if (inactivityDays <= 0) {
                    InactiveBranchFilterTrait.logDecision(listener, name, false, "inactive-filter-disabled");
                    return false;
                }
                SCMSource source = InactiveBranchFilterTrait.extractSource(request);
                if (source == null) {
                    InactiveBranchFilterTrait.logDecision(listener, name, false, "scm-source-unavailable");
                    return false;
                }
                SCMFileSystem fileSystem = SCMFileSystem.of((SCMSource)source, (SCMHead)head);
                if (fileSystem == null) {
                    InactiveBranchFilterTrait.logDecision(listener, name, false, "scm-filesystem-unavailable");
                    return false;
                }
                try (SCMFileSystem closeable = fileSystem;){
                    long lastModified = closeable.lastModified();
                    if (lastModified <= 0L) {
                        InactiveBranchFilterTrait.logDecision(listener, name, false, "last-modified-unavailable");
                        boolean bl2 = false;
                        return bl2;
                    }
                    long cutoff = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(inactivityDays);
                    boolean excluded = lastModified < cutoff;
                    InactiveBranchFilterTrait.logDecision(listener, name, excluded, "age-check lastModified=" + String.valueOf(new Date(lastModified)) + " cutoff=" + String.valueOf(new Date(cutoff)));
                    boolean bl = excluded;
                    return bl;
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.log(Level.FINE, "SCMFileSystem does not support lastModified for {0}", name);
                    InactiveBranchFilterTrait.logDecision(listener, name, false, "last-modified-unsupported");
                    return false;
                }
            }
        });
    }

    private static String normalizeList(String raw) {
        if (raw == null) {
            return "";
        }
        return raw.trim();
    }

    private static List<Pattern> parsePatternList(String raw) {
        if (raw == null) {
            return Collections.emptyList();
        }
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Pattern> entries = new LinkedHashSet<Pattern>();
        for (String entry : trimmed.split(SPLIT_REGEX)) {
            String name = entry.trim();
            if (name.isEmpty()) continue;
            try {
                entries.add(Pattern.compile(name));
            }
            catch (PatternSyntaxException e) {
                LOGGER.log(Level.WARNING, "Invalid regex in branch filter list: {0}", name);
            }
        }
        return List.copyOf(entries);
    }

    private static boolean matchesAny(String name, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private static void logDecision(TaskListener listener, String name, boolean excluded, String reason) {
        listener.getLogger().println("InactiveBranchFilter: " + name + " decision=" + (excluded ? "exclude" : "include") + " reason=" + reason);
    }

    private static SCMSource extractSource(SCMSourceRequest request) {
        Field field = InactiveBranchFilterTrait.getSourceField();
        if (field == null) {
            return null;
        }
        try {
            return (SCMSource)field.get(request);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.FINE, "Unable to access SCMSource from request", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Field getSourceField() {
        if (sourceFieldInitialized) {
            return sourceField;
        }
        Class<InactiveBranchFilterTrait> clazz = InactiveBranchFilterTrait.class;
        synchronized (InactiveBranchFilterTrait.class) {
            if (!sourceFieldInitialized) {
                try {
                    Field field = SCMSourceRequest.class.getDeclaredField("source");
                    field.setAccessible(true);
                    sourceField = field;
                }
                catch (NoSuchFieldException | RuntimeException e) {
                    LOGGER.log(Level.FINE, "Unable to locate SCMSourceRequest source field", e);
                    sourceField = null;
                }
                sourceFieldInitialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sourceField;
        }
    }

    @Extension
    @Symbol(value={"inactiveBranchFilter"})
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return "Filter inactive branches";
        }
    }
}

