/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.multibranch.buildstrategy;

import com.igalg.jenkins.plugins.multibranch.buildstrategy.AbstractBranchBuildStrategy;
import com.igalg.jenkins.plugins.multibranch.buildstrategy.AbstractRegionBranchBuildStrategy;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.tools.ant.types.selectors.SelectorUtils;

abstract class ExcludeRegionBranchBuildStrategy
extends AbstractRegionBranchBuildStrategy {
    private static final Logger LOGGER = Logger.getLogger(ExcludeRegionBranchBuildStrategy.class.getName());

    protected ExcludeRegionBranchBuildStrategy() {
        super(AbstractBranchBuildStrategy.Strategy.EXCLUDED);
    }

    @Override
    boolean shouldRunBuild(Set<String> patterns, Set<String> paths) {
        for (String path : paths) {
            boolean isNotMatchingAnyRegion = true;
            for (String pattern : patterns) {
                if (SelectorUtils.matchPath((String)pattern, (String)path)) {
                    LOGGER.fine(() -> "Matched excluded region: " + pattern + " with file path: " + path);
                    isNotMatchingAnyRegion = false;
                    break;
                }
                LOGGER.fine(() -> "Not matching excluded region: " + pattern + " with file path: " + path);
            }
            if (!isNotMatchingAnyRegion) continue;
            LOGGER.info(() -> "File: " + path + " does not match any excluded region " + String.valueOf(patterns) + ", build should be triggered");
            return true;
        }
        LOGGER.info(() -> "All changes matching excluded regions, skipping build");
        return false;
    }
}

