/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.XStreamAlias;

public enum TransportFormat {
    SERIALIZED("application/x-java-serialized-object"),
    XML("text/xml; charset=utf-8"),
    JSON("application/json"),
    GSON("application/json");

    private static final String NULL_VALUE = "null";
    private final String code;
    private final String mimeType;

    private TransportFormat(String mimeType) {
        this.mimeType = mimeType;
        this.code = this.toString().toLowerCase(Locale.ENGLISH);
    }

    public static TransportFormat valueOfIgnoreCase(String transportFormat) {
        return TransportFormat.valueOf(transportFormat.toUpperCase(Locale.ENGLISH).trim());
    }

    public static boolean isATransportFormat(String format) {
        if (format == null) {
            return false;
        }
        String upperCase = format.toUpperCase(Locale.ENGLISH).trim();
        for (TransportFormat transportFormat : TransportFormat.values()) {
            if (!transportFormat.toString().equals(upperCase)) continue;
            return true;
        }
        return false;
    }

    public String getCode() {
        return this.code;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void checkDependencies() throws IOException {
        if (this == XML || this == JSON) {
            try {
                Class.forName("com.thoughtworks.xstream.XStream");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Classes of the XStream library not found. Add the XStream dependency in your webapp for the XML or JSON formats.", e);
            }
        }
        if (this == XML) {
            try {
                Class.forName("org.xmlpull.v1.XmlPullParser");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Classes of the XPP3 library not found. Add the XPP3 dependency in your webapp for the XML format.", e);
            }
        }
        if (this == GSON) {
            try {
                Class.forName("com.google.gson.Gson");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Classes of the Gson library not found. Add the Gson dependency in your webapp for the GSON format.", e);
            }
        }
    }

    public void writeSerializableTo(Serializable serializable, OutputStream output) throws IOException {
        Object nonNullSerializable = serializable == null ? NULL_VALUE : serializable;
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
        switch (this.ordinal()) {
            case 0: {
                try (ObjectOutputStream out = new ObjectOutputStream(bufferedOutput);){
                    out.writeObject(nonNullSerializable);
                    break;
                }
            }
            case 1: {
                XmlIO.writeToXml((Serializable)nonNullSerializable, bufferedOutput);
                break;
            }
            case 2: {
                XmlIO.writeToJson((Serializable)nonNullSerializable, bufferedOutput);
                break;
            }
            case 3: {
                GsonIO.writeToGson((Serializable)nonNullSerializable, bufferedOutput);
                break;
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
    }

    Serializable readSerializableFrom(InputStream input) throws IOException, ClassNotFoundException {
        Object result;
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        switch (this.ordinal()) {
            case 0: {
                try (ObjectInputStream in = TransportFormat.createObjectInputStream(bufferedInput);){
                    result = in.readObject();
                    break;
                }
            }
            case 1: {
                result = XmlIO.readFromXml(bufferedInput);
                break;
            }
            case 2: {
                throw new UnsupportedOperationException();
            }
            case 3: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
        if (NULL_VALUE.equals(result)) {
            return null;
        }
        return (Serializable)result;
    }

    static ObjectInputStream createObjectInputStream(InputStream input) throws IOException {
        return new MyObjectInputStream(input);
    }

    private static final class XmlIO {
        private static final String PACKAGE_NAME = TransportFormat.class.getName().substring(0, TransportFormat.class.getName().length() - TransportFormat.class.getSimpleName().length() - 1);
        private static final String XML_CHARSET_NAME = "utf-8";

        private XmlIO() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void writeToXml(Serializable serializable, BufferedOutputStream bufferedOutput) throws IOException {
            XStream xstream = XmlIO.createXStream(false);
            try (CompactWriter writer = new CompactWriter((Writer)new OutputStreamWriter((OutputStream)bufferedOutput, XML_CHARSET_NAME));){
                xstream.marshal((Object)serializable, (HierarchicalStreamWriter)writer);
            }
        }

        static Object readFromXml(InputStream bufferedInput) throws IOException {
            XStream xstream = XmlIO.createXStream(false);
            xstream.addPermission(NoTypePermission.NONE);
            xstream.addPermission(NullPermission.NULL);
            xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
            xstream.allowTypesByWildcard(new String[]{"java.lang.*", "java.util.*", "java.util.concurrent.*"});
            xstream.allowTypesByWildcard(new String[]{PACKAGE_NAME + ".*"});
            try (InputStreamReader reader = new InputStreamReader(bufferedInput, XML_CHARSET_NAME);){
                Object object = xstream.fromXML((Reader)reader);
                return object;
            }
        }

        static void writeToJson(Serializable serializable, BufferedOutputStream bufferedOutput) throws IOException {
            XStream xstream = XmlIO.createXStream(true);
            try (BufferedOutputStream bufferedOutputStream = bufferedOutput;){
                xstream.toXML((Object)serializable, (OutputStream)bufferedOutput);
            }
        }

        private static XStream createXStream(boolean json) {
            XStream xstream = json ? new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver()) : new XStream();
            for (Map.Entry<String, Class<?>> entry : XStreamAlias.getMap().entrySet()) {
                xstream.alias(entry.getKey(), entry.getValue());
            }
            MapConverter mapConverter = new MapConverter(xstream.getMapper()){

                public boolean canConvert(Class type) {
                    return true;
                }
            };
            xstream.registerLocalConverter(Counter.class, "requests", (Converter)mapConverter);
            xstream.registerLocalConverter(Counter.class, "rootCurrentContextsByThreadId", (Converter)mapConverter);
            CollectionConverter collectionConverter = new CollectionConverter(xstream.getMapper()){

                public boolean canConvert(Class type) {
                    if (type != null) {
                        return Collections.emptyList().getClass().equals(type);
                    }
                    return super.canConvert(type);
                }

                public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                    return Collections.emptyList();
                }
            };
            xstream.registerConverter((Converter)collectionConverter);
            return xstream;
        }
    }

    private static final class GsonIO {
        private static final Charset GSON_CHARSET = StandardCharsets.UTF_8;

        private GsonIO() {
        }

        static void writeToGson(Serializable serializable, BufferedOutputStream bufferedOutput) throws IOException {
            JsonSerializer stackTraceElementJsonSerializer = (src, typeOfSrc, context) -> new JsonPrimitive(src.toString());
            Gson gson = new GsonBuilder().registerTypeAdapter(StackTraceElement.class, (Object)stackTraceElementJsonSerializer).create();
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedOutput, GSON_CHARSET);){
                gson.toJson((Object)serializable, (Appendable)writer);
            }
        }
    }

    private static class MyObjectInputStream
    extends ObjectInputStream {
        private static final String PACKAGE_NAME = TransportFormat.class.getName().substring(0, TransportFormat.class.getName().length() - TransportFormat.class.getSimpleName().length() - 1);

        MyObjectInputStream(InputStream input) throws IOException {
            super(input);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            int i = 0;
            if (name.indexOf("[[") == 0) {
                ++i;
            }
            if (name.indexOf("[L", i) == i) {
                i += 2;
            }
            if (name.indexOf("java.lang.", i) == i || name.indexOf("java.util.", i) == i || name.indexOf("java.io.", i) == i || name.indexOf(PACKAGE_NAME, i) == i || name.length() <= 2) {
                return super.resolveClass(desc);
            }
            if (name.indexOf("net.bull.javamelody", i) == i) {
                return Class.forName(name.replace("net.bull.javamelody", "net.bull.javamelody.internal.model"));
            }
            throw new ClassNotFoundException(name);
        }
    }
}

