/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import hudson.Extension;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Extension
public class WaitingDurationQueueListener
extends QueueListener {
    private static final ConcurrentMap<Long, Date> START_TIMES_BY_ID = new ConcurrentHashMap<Long, Date>();

    public void onEnterWaiting(Queue.WaitingItem wi) {
        START_TIMES_BY_ID.put(wi.getId(), new Date(wi.getInQueueSince()));
    }

    public void onLeft(Queue.LeftItem li) {
        START_TIMES_BY_ID.remove(li.getId());
    }

    static long getWaitingDurationsSum() {
        long now = System.currentTimeMillis();
        long sum = 0L;
        for (Date date : START_TIMES_BY_ID.values()) {
            sum += now - date.getTime();
        }
        return Math.max(sum, 0L);
    }
}

