/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;

public class MonitoringProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1882880665014391301L;
    private static final String BEANS_ICON_NAME = "beans.png";
    private static final Counter SERVICES_COUNTER = new Counter("services", "beans.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter EJB_COUNTER = new Counter("ejb", "beans.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter JPA_COUNTER = new Counter("jpa", "db.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter SPRING_COUNTER = new Counter("spring", "beans.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter GUICE_COUNTER = new Counter("guice", "beans.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter STRUTS_COUNTER = new Counter("struts", "struts.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter JSF_COUNTER = new Counter("jsf", "jsp.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(SERVICES_COUNTER.getName());
    private static final boolean DISABLED = Parameter.DISABLED.getValueAsBoolean();
    private final Object facade;
    private final String name;

    protected MonitoringProxy(Object facade) {
        this(facade, null);
    }

    protected MonitoringProxy(Object facade, String name) {
        this.facade = facade;
        SERVICES_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        SERVICES_COUNTER.setUsed(true);
        this.name = name;
    }

    public static <T> T createProxy(T facade) {
        return MonitoringProxy.createProxy(facade, new MonitoringProxy(facade));
    }

    public static <T> T createProxy(T facade, String name) {
        return MonitoringProxy.createProxy(facade, new MonitoringProxy(facade, name));
    }

    static Counter getServicesCounter() {
        return SERVICES_COUNTER;
    }

    static Counter getEjbCounter() {
        return EJB_COUNTER;
    }

    static Counter getJpaCounter() {
        return JPA_COUNTER;
    }

    static Counter getSpringCounter() {
        return SPRING_COUNTER;
    }

    static Counter getGuiceCounter() {
        return GUICE_COUNTER;
    }

    static Counter getStrutsCounter() {
        return STRUTS_COUNTER;
    }

    static Counter getJsfCounter() {
        return JSF_COUNTER;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (DISABLED || !SERVICES_COUNTER.isDisplayed()) {
            return method.invoke(this.facade, args);
        }
        String requestName = this.getRequestName(method);
        return MonitoringProxy.invokeTarget(this.facade, method, args, requestName);
    }

    public static Object invokeTarget(Object target, Method method, Object[] args, String requestName) throws IllegalAccessException, InvocationTargetException {
        boolean systemError = false;
        try {
            SERVICES_COUNTER.bindContextIncludingCpu(requestName);
            Object object = method.invoke(target, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                systemError = true;
            }
            throw e;
        }
        finally {
            SERVICES_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    protected String getRequestName(Method method) {
        String requestName = this.name == null ? method.getDeclaringClass().getSimpleName() + "." + method.getName() : this.name + "." + method.getName();
        return requestName;
    }

    protected String getName() {
        return this.name;
    }

    protected static <T> T createProxy(T facade, MonitoringProxy monitoringProxy) {
        return JdbcWrapper.createProxy(facade, monitoringProxy);
    }
}

