/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import hudson.Plugin;
import hudson.init.InitMilestone;
import hudson.util.PluginServletFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.util.Arrays;
import java.util.logging.LogRecord;
import jenkins.model.Jenkins;
import net.bull.javamelody.Parameter;
import org.jvnet.hudson.plugins.monitoring.HudsonMonitoringFilter;

public class PluginImpl
extends Plugin {
    private ServletContext context;
    private HudsonMonitoringFilter filter;

    public void start() throws Exception {
        super.start();
        Jenkins jenkins = Jenkins.getInstance();
        this.context = jenkins.getServletContext();
        CsrfThread thread = new CsrfThread();
        thread.setName("javamelody-initializer");
        thread.setDaemon(true);
        thread.start();
        if (this.isParameterUndefined(Parameter.SYSTEM_ACTIONS_ENABLED)) {
            Parameter.SYSTEM_ACTIONS_ENABLED.setValue("true");
        }
        if (this.isParameterUndefined(Parameter.NO_DATABASE)) {
            Parameter.NO_DATABASE.setValue("true");
        }
        if (this.isParameterUndefined(Parameter.STORAGE_DIRECTORY)) {
            Parameter.STORAGE_DIRECTORY.setValue("/" + new File(jenkins.getRootDir(), "monitoring").getAbsolutePath());
        }
        if (this.isParameterUndefined(Parameter.HTTP_TRANSFORM_PATTERN)) {
            Parameter.HTTP_TRANSFORM_PATTERN.setValue("/\\d+/|(?<=/static/|/adjuncts/|/bound/)[\\w\\-]+|(?<=/ws/|/user/|/testReport/|/javadoc/|/site/|/violations/file/|/cobertura/).+|(?<=/job/).+(?=/descriptorByName/)");
        }
        if (this.isParameterUndefined(Parameter.CUSTOM_REPORTS)) {
            Parameter.CUSTOM_REPORTS.setValue("Jenkins Info,About Monitoring");
            System.setProperty("javamelody.Jenkins Info", "/systemInfo");
            System.setProperty("javamelody.About Monitoring", "https://plugins.jenkins.io/monitoring/");
        }
        if (this.isParameterUndefined(Parameter.GZIP_COMPRESSION_DISABLED)) {
            Parameter.GZIP_COMPRESSION_DISABLED.setValue("true");
        }
        if (this.isParameterUndefined(Parameter.MAVEN_REPOSITORIES)) {
            String mavenRepositories = System.getProperty("user.home") + "/.m2/repository,http://repo1.maven.org/maven2,http://repo.jenkins-ci.org/public";
            Parameter.MAVEN_REPOSITORIES.setValue(mavenRepositories);
        }
        Arrays.hashCode(new Class[]{LogRecord.class});
        this.filter = new HudsonMonitoringFilter();
        PluginServletFilter.addFilter((Filter)this.filter);
    }

    private boolean isParameterUndefined(Parameter parameter) {
        String key = "javamelody." + parameter.getCode();
        return this.isParameterUndefined(key);
    }

    private boolean isParameterUndefined(String key) {
        return System.getProperty(key) == null && this.context != null && this.context.getInitParameter(key) == null;
    }

    HudsonMonitoringFilter getFilter() {
        return this.filter;
    }

    public void postInitialize() throws Exception {
        super.postInitialize();
        if (this.filter == null) {
            throw new Exception("Post-initialization hook has been called before the plugin start. Filters are not available");
        }
        this.filter.getNodesCollector().init();
    }

    public void stop() throws Exception {
        if (this.filter != null && this.filter.getNodesCollector() != null) {
            this.filter.getNodesCollector().stop();
        }
        super.stop();
    }

    private static class CsrfThread
    extends Thread {
        CsrfThread() {
        }

        @Override
        public void run() {
            Jenkins jenkins = Jenkins.getInstance();
            while (jenkins.getInitLevel() != InitMilestone.COMPLETED) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (jenkins.isUseCrumbs()) {
                Parameter.CSRF_PROTECTION_ENABLED.setValue("true");
            }
        }
    }
}

