/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.MessageDigestPasswordEncoder;
import net.bull.javamelody.internal.model.Base64Coder;

public class HttpAuth {
    private static final long AUTH_FAILURES_MAX = 10L;
    private static final long LOCK_DURATION = 3600000L;
    private final Pattern allowedAddrPattern;
    private final List<String> authorizedUsers;
    private final AtomicInteger authFailuresCount = new AtomicInteger();
    private Date firstFailureDate;

    public HttpAuth() {
        this.allowedAddrPattern = HttpAuth.getAllowedAddrPattern();
        this.authorizedUsers = HttpAuth.getAuthorizedUsers();
    }

    private static Pattern getAllowedAddrPattern() {
        if (Parameter.ALLOWED_ADDR_PATTERN.getValue() != null) {
            return Pattern.compile(Parameter.ALLOWED_ADDR_PATTERN.getValue());
        }
        return null;
    }

    private static List<String> getAuthorizedUsers() {
        String authUsersInParam = Parameter.AUTHORIZED_USERS.getValue();
        if (authUsersInParam != null && !authUsersInParam.trim().isEmpty()) {
            ArrayList<String> authorizedUsers = new ArrayList<String>();
            for (String authUser : authUsersInParam.split("[\n,]")) {
                String authUserTrim = authUser.trim();
                if (authUserTrim.isEmpty()) continue;
                authorizedUsers.add(authUserTrim);
                LOG.debug("Authorized user: " + authUserTrim.split(":", 2)[0]);
            }
            return authorizedUsers;
        }
        return null;
    }

    public boolean isAllowed(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (!this.isRequestAllowed(httpRequest)) {
            LOG.debug("Forbidden access to monitoring from " + httpRequest.getRemoteAddr());
            httpResponse.sendError(403, "Forbidden access");
            return false;
        }
        if (!this.isUserAuthorized(httpRequest)) {
            httpResponse.setHeader("WWW-Authenticate", "BASIC realm=\"JavaMelody\"");
            if (this.isLocked()) {
                httpResponse.sendError(401, "Unauthorized (locked)");
            } else {
                httpResponse.sendError(401, "Unauthorized");
            }
            return false;
        }
        return true;
    }

    private boolean isRequestAllowed(HttpServletRequest httpRequest) {
        return this.allowedAddrPattern == null || this.allowedAddrPattern.matcher(httpRequest.getRemoteAddr()).matches();
    }

    private boolean isUserAuthorized(HttpServletRequest httpRequest) throws IOException {
        if (this.authorizedUsers == null) {
            return true;
        }
        String auth = httpRequest.getHeader("Authorization");
        if (auth == null) {
            return false;
        }
        if (!auth.toUpperCase(Locale.ENGLISH).startsWith("BASIC ")) {
            return false;
        }
        String userpassBase64 = auth.substring("BASIC ".length());
        String userpass = Base64Coder.decodeString(userpassBase64);
        boolean authOk = false;
        for (String authorizedUser : this.authorizedUsers) {
            String userpassEncoded = this.getUserPasswordEncoded(userpass, authorizedUser);
            if (userpassEncoded != null) {
                if (!authorizedUser.equals(userpassEncoded)) continue;
                authOk = true;
                break;
            }
            if (!authorizedUser.equals(userpass)) continue;
            authOk = true;
            break;
        }
        return this.checkLockAgainstBruteForceAttack(authOk);
    }

    private String getUserPasswordEncoded(String userpassDecoded, String authorizedUser) throws IOException {
        int indexOfEnd;
        int indexOfStart = authorizedUser.indexOf(":{");
        if (indexOfStart != -1 && (indexOfEnd = authorizedUser.indexOf(125, indexOfStart)) != -1) {
            String algorithm = authorizedUser.substring(indexOfStart + 2, indexOfEnd);
            int indexOfColon = userpassDecoded.indexOf(58);
            if (indexOfColon != -1) {
                String pass = userpassDecoded.substring(indexOfColon + 1);
                return userpassDecoded.substring(0, indexOfColon + 1) + this.encodePassword(algorithm, pass);
            }
        }
        return null;
    }

    private String encodePassword(String algorithm, String password) throws IOException {
        try {
            return new MessageDigestPasswordEncoder(algorithm).encodePassword(password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private boolean checkLockAgainstBruteForceAttack(boolean authOk) {
        if (this.firstFailureDate == null) {
            if (!authOk) {
                this.firstFailureDate = new Date();
                this.authFailuresCount.set(1);
            }
        } else {
            if (this.isLocked()) {
                if (System.currentTimeMillis() - this.firstFailureDate.getTime() < 3600000L) {
                    return false;
                }
                this.firstFailureDate = null;
                this.authFailuresCount.set(0);
                return this.checkLockAgainstBruteForceAttack(authOk);
            }
            if (authOk) {
                this.firstFailureDate = null;
                this.authFailuresCount.set(0);
            } else {
                this.authFailuresCount.incrementAndGet();
            }
        }
        return authOk;
    }

    private boolean isLocked() {
        return (long)this.authFailuresCount.get() > 10L;
    }
}

