/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.jrobin.core.RrdFileBackend;

public class RrdNioBackend
extends RrdFileBackend {
    private static final Object THE_UNSAFE = RrdNioBackend.getTheUnsafe();
    private static final Method JAVA9_INVOKE_CLEANER = RrdNioBackend.getJava9InvokeCleaner();
    private static Timer fileSyncTimer;
    private MappedByteBuffer byteBuffer;
    private final TimerTask syncTask = new TimerTask(){

        @Override
        public void run() {
            RrdNioBackend.this.sync();
        }
    };

    protected RrdNioBackend(String path, boolean readOnly, int syncPeriod) throws IOException {
        super(path, readOnly);
        try {
            this.mapFile();
            if (!readOnly) {
                fileSyncTimer.schedule(this.syncTask, (long)syncPeriod * 1000L, (long)syncPeriod * 1000L);
            }
        }
        catch (IOException ioe) {
            super.close();
            throw ioe;
        }
        catch (IllegalStateException e) {
            this.unmapFile();
            super.close();
            throw e;
        }
    }

    public static Timer getFileSyncTimer() {
        return fileSyncTimer;
    }

    public static void setFileSyncTimer(Timer timer) {
        fileSyncTimer = timer;
    }

    private void mapFile() throws IOException {
        long length = this.getLength();
        if (length > 0L) {
            FileChannel.MapMode mapMode = FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.file.getChannel().map(mapMode, 0L, length);
        }
    }

    private void unmapFile() {
        if (this.byteBuffer != null) {
            if (JAVA9_INVOKE_CLEANER == null || THE_UNSAFE == null) {
                try {
                    Class.forName("sun.misc.Unsafe");
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                throw new IllegalStateException("sun.misc.Unsafe unavailable to unmap file");
            }
            try {
                JAVA9_INVOKE_CLEANER.invoke(THE_UNSAFE, this.byteBuffer);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.byteBuffer = null;
        }
    }

    private static Object getTheUnsafe() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            return theUnsafeField.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Method getJava9InvokeCleaner() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            return unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected synchronized void setLength(long newLength) throws IOException {
        this.unmapFile();
        super.setLength(newLength);
        this.mapFile();
    }

    protected synchronized void write(long offset, byte[] b) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Write failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)offset);
        this.byteBuffer.put(b);
    }

    protected synchronized void read(long offset, byte[] b) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Read failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)offset);
        this.byteBuffer.get(b);
    }

    public synchronized void close() throws IOException {
        try {
            if (this.syncTask != null) {
                this.syncTask.cancel();
            }
            this.sync();
            this.unmapFile();
        }
        finally {
            super.close();
        }
    }

    protected synchronized void sync() {
        if (this.byteBuffer != null) {
            this.byteBuffer.force();
        }
    }
}

