/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.PID;
import net.bull.javamelody.internal.model.QuartzAdapter;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.SchedulerRepository;

public class JobInformations
implements Serializable {
    public static final boolean QUARTZ_AVAILABLE = JobInformations.isQuartzAvailable();
    private static final long serialVersionUID = -2826168112578815952L;
    private final String group;
    private final String name;
    private final String description;
    private final String jobClassName;
    private final Date previousFireTime;
    private final Date nextFireTime;
    private final long elapsedTime;
    private final long repeatInterval;
    private final String cronExpression;
    private final boolean paused;
    private final String globalJobId;

    JobInformations(JobDetail jobDetail, JobExecutionContext jobExecutionContext, Scheduler scheduler) throws SchedulerException {
        assert (jobDetail != null);
        assert (scheduler != null);
        QuartzAdapter quartzAdapter = QuartzAdapter.getSingleton();
        this.group = quartzAdapter.getJobGroup(jobDetail);
        this.name = quartzAdapter.getJobName(jobDetail);
        this.description = quartzAdapter.getJobDescription(jobDetail);
        this.jobClassName = quartzAdapter.getJobClass(jobDetail).getName();
        this.elapsedTime = jobExecutionContext == null ? -1L : System.currentTimeMillis() - quartzAdapter.getContextFireTime(jobExecutionContext).getTime();
        List<Trigger> triggers = quartzAdapter.getTriggersOfJob(jobDetail, scheduler);
        this.previousFireTime = this.getPreviousFireTime(triggers);
        this.nextFireTime = this.getNextFireTime(triggers);
        String cronTriggerExpression = null;
        long simpleTriggerRepeatInterval = -1L;
        boolean jobPaused = true;
        for (Trigger trigger : triggers) {
            if (trigger instanceof CronTrigger) {
                cronTriggerExpression = quartzAdapter.getCronTriggerExpression((CronTrigger)trigger);
            } else if (trigger instanceof SimpleTrigger) {
                simpleTriggerRepeatInterval = quartzAdapter.getSimpleTriggerRepeatInterval((SimpleTrigger)trigger);
            }
            jobPaused = jobPaused && quartzAdapter.isTriggerPaused(trigger, scheduler);
        }
        this.repeatInterval = simpleTriggerRepeatInterval;
        this.cronExpression = cronTriggerExpression;
        this.paused = jobPaused;
        this.globalJobId = PID.getPID() + "_" + Parameters.getHostAddress() + "_" + quartzAdapter.getJobFullName(jobDetail).hashCode();
    }

    private Date getNextFireTime(List<Trigger> triggers) {
        QuartzAdapter quartzAdapter = QuartzAdapter.getSingleton();
        Date myNextFireTime = null;
        for (Trigger trigger : triggers) {
            Date triggerNextFireTime = quartzAdapter.getTriggerNextFireTime(trigger);
            if (myNextFireTime != null && (triggerNextFireTime == null || !myNextFireTime.after(triggerNextFireTime))) continue;
            myNextFireTime = triggerNextFireTime;
        }
        return myNextFireTime;
    }

    private Date getPreviousFireTime(List<Trigger> triggers) {
        QuartzAdapter quartzAdapter = QuartzAdapter.getSingleton();
        Date myPreviousFireTime = null;
        for (Trigger trigger : triggers) {
            Date triggerPreviousFireTime = quartzAdapter.getTriggerPreviousFireTime(trigger);
            if (myPreviousFireTime != null && (triggerPreviousFireTime == null || !myPreviousFireTime.before(triggerPreviousFireTime))) continue;
            myPreviousFireTime = triggerPreviousFireTime;
        }
        return myPreviousFireTime;
    }

    private static boolean isQuartzAvailable() {
        try {
            Class.forName("org.quartz.Job");
            Class.forName("org.quartz.impl.SchedulerRepository");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<JobInformations> buildJobInformationsList() {
        if (!QUARTZ_AVAILABLE) {
            return Collections.emptyList();
        }
        ArrayList<JobInformations> result = new ArrayList<JobInformations>();
        try {
            QuartzAdapter quartzAdapter = QuartzAdapter.getSingleton();
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                LinkedHashMap<String, JobExecutionContext> currentlyExecutingJobsByFullName = new LinkedHashMap<String, JobExecutionContext>();
                for (JobExecutionContext currentlyExecutingJob : scheduler.getCurrentlyExecutingJobs()) {
                    JobDetail jobDetail = quartzAdapter.getContextJobDetail(currentlyExecutingJob);
                    String jobFullName = quartzAdapter.getJobFullName(jobDetail);
                    currentlyExecutingJobsByFullName.put(jobFullName, currentlyExecutingJob);
                }
                try {
                    for (JobDetail jobDetail : quartzAdapter.getAllJobsOfScheduler(scheduler)) {
                        String jobFullName = quartzAdapter.getJobFullName(jobDetail);
                        JobExecutionContext jobExecutionContext = (JobExecutionContext)currentlyExecutingJobsByFullName.get(jobFullName);
                        result.add(new JobInformations(jobDetail, jobExecutionContext, scheduler));
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.toString(), e);
                    return Collections.emptyList();
                    return result;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<Scheduler> getAllSchedulers() {
        return new ArrayList<Scheduler>(SchedulerRepository.getInstance().lookupAll());
    }

    public String getGlobalJobId() {
        return this.globalJobId;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJobClassName() {
        return this.jobClassName;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    boolean isCurrentlyExecuting() {
        return this.elapsedTime >= 0L;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", group=" + this.getGroup() + "]";
    }
}

