/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Period;
import org.jrobin.core.Util;

public final class Range
implements Serializable {
    public static final char CUSTOM_PERIOD_SEPARATOR = '|';
    private static final long serialVersionUID = 4658258882827669495L;
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private final Period period;
    private final Date startDate;
    private final Date endDate;

    private Range(Period period, Date startDate, Date endDate) {
        assert (period != null && startDate == null && endDate == null || period == null && startDate != null && endDate != null && startDate.getTime() <= endDate.getTime());
        this.period = period;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    static Range createPeriodRange(Period period) {
        return new Range(period, null, null);
    }

    public static Range createCustomRange(Date startDate, Date endDate) {
        Calendar calendar;
        Date normalizedStartDate = startDate;
        Date normalizedEndDate = endDate;
        Calendar minimum = Calendar.getInstance();
        minimum.add(1, -2);
        if (normalizedStartDate.getTime() < minimum.getTimeInMillis()) {
            normalizedStartDate = minimum.getTime();
        }
        if (normalizedStartDate.getTime() > System.currentTimeMillis()) {
            normalizedStartDate = new Date();
            calendar = Calendar.getInstance();
            calendar.setTime(normalizedStartDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            normalizedStartDate = calendar.getTime();
        }
        if (normalizedEndDate.getTime() > System.currentTimeMillis()) {
            normalizedEndDate = new Date();
        }
        if (normalizedStartDate.after(normalizedEndDate)) {
            normalizedEndDate = normalizedStartDate;
        }
        calendar = Calendar.getInstance();
        calendar.setTime(normalizedEndDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        normalizedEndDate = calendar.getTime();
        return new Range(null, normalizedStartDate, normalizedEndDate);
    }

    public static Range parse(String value, DateFormat dateFormat) {
        Date endDate;
        Date startDate;
        int index = value.indexOf(124);
        if (index == -1) {
            try {
                return Period.valueOfIgnoreCase(value).getRange();
            }
            catch (IllegalArgumentException e) {
                return Period.JOUR.getRange();
            }
        }
        try {
            startDate = dateFormat.parse(value.substring(0, index));
        }
        catch (ParseException e) {
            startDate = new Date();
        }
        if (index < value.length() - 1) {
            try {
                endDate = dateFormat.parse(value.substring(index + 1));
            }
            catch (ParseException e) {
                endDate = new Date();
            }
        } else {
            endDate = new Date();
        }
        return Range.createCustomRange(startDate, endDate);
    }

    public Period getPeriod() {
        return this.period;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    long getJRobinStartTime() {
        if (this.period == null) {
            return this.startDate.getTime() / 1000L;
        }
        return Util.getTime() - (long)this.period.getDurationSeconds();
    }

    long getJRobinEndTime() {
        if (this.period == null) {
            return Math.min(this.endDate.getTime() / 1000L, Util.getTime());
        }
        return Util.getTime();
    }

    public String getValue() {
        if (this.period == null) {
            DateFormat dateFormat = I18N.createDateFormat();
            return dateFormat.format(this.startDate) + "|" + dateFormat.format(this.endDate);
        }
        return this.period.getCode();
    }

    public String getLabel() {
        if (this.period == null) {
            DateFormat dateFormat = I18N.createDateFormat();
            return dateFormat.format(this.startDate) + " - " + dateFormat.format(this.endDate);
        }
        return this.period.getLabel();
    }

    int getDurationDays() {
        if (this.period == null) {
            return (int)((this.endDate.getTime() + 1000L - this.startDate.getTime()) / 86400000L);
        }
        return this.period.getDurationDays();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[period=" + this.getPeriod() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + "]";
    }
}

