/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.text.DecimalFormat;
import org.jrobin.inspector.ArchiveTableModel;
import org.jrobin.inspector.DataTableModel;
import org.jrobin.inspector.DatasourceTableModel;
import org.jrobin.inspector.HeaderTableModel;
import org.jrobin.inspector.MainTreeModel;

class InspectorModel {
    private MainTreeModel mainTreeModel = new MainTreeModel();
    private HeaderTableModel generalTableModel = new HeaderTableModel();
    private DatasourceTableModel datasourceTableModel = new DatasourceTableModel();
    private ArchiveTableModel archiveTableModel = new ArchiveTableModel();
    private DataTableModel dataTableModel = new DataTableModel();
    private File file;
    private boolean ok = false;
    private static String DOUBLE_FORMAT = "0.0000000000E00";
    private static final DecimalFormat df = new DecimalFormat(DOUBLE_FORMAT);

    InspectorModel() {
    }

    MainTreeModel getMainTreeModel() {
        return this.mainTreeModel;
    }

    HeaderTableModel getGeneralTableModel() {
        return this.generalTableModel;
    }

    DatasourceTableModel getDatasourceTableModel() {
        return this.datasourceTableModel;
    }

    DataTableModel getDataTableModel() {
        return this.dataTableModel;
    }

    ArchiveTableModel getArchiveTableModel() {
        return this.archiveTableModel;
    }

    void setFile(File file) {
        this.file = file;
        this.ok = this.mainTreeModel.setFile(file);
        this.generalTableModel.setFile(file);
        this.datasourceTableModel.setFile(file);
        this.archiveTableModel.setFile(file);
        this.dataTableModel.setFile(file);
    }

    void refresh() {
        this.setFile(this.file);
    }

    void selectModel(int dsIndex, int arcIndex) {
        this.datasourceTableModel.setIndex(dsIndex);
        this.archiveTableModel.setIndex(dsIndex, arcIndex);
        this.dataTableModel.setIndex(dsIndex, arcIndex);
    }

    File getFile() {
        return this.file;
    }

    boolean isOk() {
        return this.ok;
    }

    static String formatDouble(double x, String nanString) {
        if (Double.isNaN(x)) {
            return nanString;
        }
        return df.format(x);
    }

    static String formatDouble(double x) {
        return InspectorModel.formatDouble(x, "NaN");
    }
}

