/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.Arrays;
import org.jrobin.core.Util;

class Normalizer {
    private final double[] timestamps;
    final int count;
    final double step;

    Normalizer(long tStart, long tEnd, int count) {
        this.count = count;
        this.step = (tEnd - tStart) / (long)(count - 1);
        this.timestamps = new double[count];
        int i = 0;
        while (i < count) {
            this.timestamps[i] = (double)tStart + (double)i / (double)(count - 1) * (double)(tEnd - tStart);
            ++i;
        }
    }

    double[] getTimestamps() {
        return this.timestamps;
    }

    double[] normalize(long[] rawTimestamps, double[] rawValues) {
        int rawCount = rawTimestamps.length;
        long rawStep = rawTimestamps[1] - rawTimestamps[0];
        if (rawCount == this.count && (double)rawStep == this.step && (double)rawTimestamps[0] == this.timestamps[0]) {
            return Normalizer.getCopyOf(rawValues);
        }
        double[] values = new double[this.count];
        Arrays.fill(values, Double.NaN);
        int rawSeg = 0;
        int seg = 0;
        while (rawSeg < rawCount && seg < this.count) {
            double rawValue = rawValues[rawSeg];
            if (!Double.isNaN(rawValue)) {
                long rawLeft = rawTimestamps[rawSeg] - rawStep;
                while (seg < this.count && (double)rawLeft >= this.timestamps[seg]) {
                    ++seg;
                }
                boolean overlap = true;
                int fillSeg = seg;
                while (overlap && fillSeg < this.count) {
                    double t2;
                    double left = this.timestamps[fillSeg] - this.step;
                    double t1 = Math.max((double)rawLeft, left);
                    if (t1 < (t2 = Math.min((double)rawTimestamps[rawSeg], this.timestamps[fillSeg]))) {
                        values[fillSeg] = Util.sum(values[fillSeg], (t2 - t1) * rawValues[rawSeg]);
                    } else {
                        overlap = false;
                    }
                    ++fillSeg;
                }
            }
            ++rawSeg;
        }
        int seg2 = 0;
        while (seg2 < this.count) {
            int n = seg2++;
            values[n] = values[n] / this.step;
        }
        return values;
    }

    private static double[] getCopyOf(double[] rawValues) {
        int n = rawValues.length;
        double[] values = new double[n];
        System.arraycopy(rawValues, 0, values, 0, n);
        return values;
    }
}

