/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.MBeans;

public class JCacheInformations
implements Serializable {
    private static final long serialVersionUID = -3025833425994923286L;
    private static final MBeanServer MBEAN_SERVER = MBeans.getPlatformMBeanServer();
    private static final boolean JCACHE_AVAILABLE = JCacheInformations.isJCacheAvailable();
    private final String name;
    private final long cacheHits;
    private final long cacheMisses;
    private boolean availableByApi;
    private List<?> cacheKeys;

    JCacheInformations(ObjectName cache) {
        assert (cache != null);
        this.name = cache.getKeyProperty("Cache");
        this.cacheHits = JCacheInformations.getValue(cache, "CacheHits");
        this.cacheMisses = JCacheInformations.getValue(cache, "CacheMisses");
    }

    JCacheInformations(String cacheName) {
        assert (cacheName != null);
        this.name = cacheName;
        this.cacheHits = -1L;
        this.cacheMisses = 1L;
    }

    private static Long getValue(ObjectName cache, String attribute) {
        try {
            return (Long)MBEAN_SERVER.getAttribute(cache, attribute);
        }
        catch (JMException e) {
            return -1L;
        }
    }

    static List<JCacheInformations> buildJCacheInformationsList() {
        if (!JCACHE_AVAILABLE) {
            return Collections.emptyList();
        }
        ArrayList<JCacheInformations> result = new ArrayList<JCacheInformations>();
        Set<ObjectName> cacheStatistics = JCacheInformations.getJsr107CacheStatistics();
        for (ObjectName cache : cacheStatistics) {
            JCacheInformations jcacheInformations = new JCacheInformations(cache);
            result.add(jcacheInformations);
        }
        for (CachingProvider cachingProvider : Caching.getCachingProviders()) {
            try {
                CacheManager cacheManager = cachingProvider.getCacheManager();
                for (String cacheName : cacheManager.getCacheNames()) {
                    boolean found = false;
                    for (JCacheInformations jcacheInformations : result) {
                        if (cacheName == null || !cacheName.equals(jcacheInformations.getName())) continue;
                        jcacheInformations.availableByApi = true;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    JCacheInformations jcacheInformations = new JCacheInformations(cacheName);
                    jcacheInformations.availableByApi = true;
                    result.add(jcacheInformations);
                }
            }
            catch (Exception e) {
                LOG.warn(e.toString(), e);
            }
        }
        return result;
    }

    public static JCacheInformations buildJCacheInformationsWithKeys(String cacheId) {
        assert (JCACHE_AVAILABLE);
        assert (cacheId != null);
        for (CachingProvider cachingProvider : Caching.getCachingProviders()) {
            try {
                CacheManager cacheManager = cachingProvider.getCacheManager();
                for (String cacheName : cacheManager.getCacheNames()) {
                    if (!cacheName.equals(cacheId)) continue;
                    Cache cache = cacheManager.getCache(cacheId);
                    ArrayList cacheKeys = new ArrayList();
                    for (Cache.Entry entry : cache) {
                        cacheKeys.add(entry.getKey());
                    }
                    for (JCacheInformations cacheInformations : JCacheInformations.buildJCacheInformationsList()) {
                        if (!cacheInformations.getName().equals(cacheId)) continue;
                        cacheInformations.cacheKeys = cacheKeys;
                        return cacheInformations;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn(e.toString(), e);
            }
        }
        throw new IllegalArgumentException("Cache not found");
    }

    private static Set<ObjectName> getJsr107CacheStatistics() {
        try {
            ObjectName objectName = new ObjectName("javax.cache:type=CacheStatistics,*");
            return MBEAN_SERVER.queryNames(objectName, null);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isJCacheAvailable() {
        try {
            Class.forName("javax.cache.Cache");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public int getHitsRatio() {
        long accessCount = this.cacheHits + this.cacheMisses;
        if (accessCount == 0L) {
            return -1;
        }
        return (int)(100L * this.cacheHits / accessCount);
    }

    public boolean isAvailableByApi() {
        return this.availableByApi;
    }

    public List<?> getCacheKeys() {
        return this.cacheKeys;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", hitsRatio=" + this.getHitsRatio() + "]";
    }
}

