/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.PreferQueryMode;

public class DatabaseInformations
implements Serializable {
    private static final long serialVersionUID = -6105478981257689782L;
    private static final boolean POSTGRESQL_DRIVER_AVAILABLE = DatabaseInformations.isPostgresqlDriverAvailable();
    private final Database database;
    private final List<String> requestNames;
    private final int selectedRequestIndex;
    private final String[][] result;

    public DatabaseInformations(int selectedRequestIndex) throws SQLException, NamingException {
        this.selectedRequestIndex = selectedRequestIndex;
        try (Connection connection = DatabaseInformations.getConnection();){
            assert (connection != null);
            this.database = Database.getDatabaseForConnection(connection);
            this.requestNames = this.database.getRequestNames();
            String request = this.database.getRequestByName(this.requestNames.get(selectedRequestIndex));
            this.result = DatabaseInformations.executeRequest(connection, request, null);
        }
    }

    public static int parseRequestIndex(String requestIndex) {
        if (requestIndex != null) {
            return Integer.parseInt(requestIndex);
        }
        return 0;
    }

    public int getNbColumns() {
        String selectedRequestName = this.getSelectedRequestName();
        if ("oracle.statistics".equals(selectedRequestName)) {
            return 2;
        }
        if ("oracle.events".equals(selectedRequestName)) {
            return 2;
        }
        if ("mysql.variables".equals(selectedRequestName)) {
            return 2;
        }
        if ("mysql.global_status".equals(selectedRequestName)) {
            return 4;
        }
        if ("h2.settings".equals(selectedRequestName)) {
            return 2;
        }
        return 1;
    }

    public int getSelectedRequestIndex() {
        return this.selectedRequestIndex;
    }

    public String getSelectedRequestName() {
        return this.requestNames.get(this.getSelectedRequestIndex());
    }

    public String[][] getResult() {
        return this.result;
    }

    public List<String> getRequestNames() {
        return this.requestNames;
    }

    private static String[][] executeRequest(Connection connection, String request, List<?> parametersValues) throws SQLException {
        String[][] i2;
        block11: {
            PreparedStatement statement = connection.prepareStatement(request);
            try {
                if (parametersValues != null) {
                    int i2 = 1;
                    for (Object parameterValue : parametersValues) {
                        statement.setObject(i2, parameterValue);
                        ++i2;
                    }
                }
                i2 = DatabaseInformations.executeQuery(statement);
                if (statement == null) break block11;
            }
            catch (Throwable i2) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            i2.addSuppressed(throwable);
                        }
                    }
                    throw i2;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 942 && e.getMessage() != null && e.getMessage().startsWith("ORA-")) {
                        String userName = connection.getMetaData().getUserName();
                        String message = I18N.getFormattedString("oracle.grantSelectAnyDictionnary", userName);
                        throw new SQLException(message, e);
                    }
                    throw e;
                }
            }
            statement.close();
        }
        return i2;
    }

    private static String[][] executeQuery(PreparedStatement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery();){
            int i;
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList<String[]> list = new ArrayList<String[]>();
            String[] values = new String[columnCount];
            for (i = 1; i <= columnCount; ++i) {
                values[i - 1] = metaData.getColumnName(i) + "\n" + metaData.getColumnTypeName(i) + "(" + metaData.getColumnDisplaySize(i) + ")";
            }
            list.add(values);
            while (resultSet.next()) {
                values = new String[columnCount];
                for (i = 1; i <= columnCount; ++i) {
                    values[i - 1] = resultSet.getString(i);
                }
                list.add(values);
            }
            String[][] stringArray = (String[][])list.toArray((T[])new String[0][]);
            return stringArray;
        }
    }

    private static Connection getConnection() throws SQLException, NamingException {
        if (Parameters.getLastConnectUrl() != null) {
            Connection connection = DriverManager.getConnection(Parameters.getLastConnectUrl(), Parameters.getLastConnectInfo());
            connection.setAutoCommit(false);
            return connection;
        }
        Collection<DataSource> dataSources = JdbcWrapper.getJndiAndSpringDataSources().values();
        for (DataSource dataSource : dataSources) {
            try {
                return dataSource.getConnection();
            }
            catch (Exception e) {
            }
        }
        if (!dataSources.isEmpty()) {
            return dataSources.iterator().next().getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String explainPlanFor(String sqlRequest) throws SQLException, NamingException {
        block33: {
            Connection connection = DatabaseInformations.getConnection();
            if (connection != null) {
                try {
                    String string;
                    PgConnection pgConnection;
                    Database database = Database.getDatabaseForConnection(connection);
                    if (database == Database.ORACLE) {
                        String statementId = String.valueOf(sqlRequest.hashCode());
                        String explainRequest = "explain plan set statement_id = '" + statementId + "' for " + DatabaseInformations.normalizeRequestForExplain(sqlRequest, ':');
                        try (Statement statement = connection.createStatement();){
                            statement.execute(explainRequest);
                        }
                        String planTableRequest = "select * from table(dbms_xplan.display(null,?,null))";
                        String[][] planTableOutput = DatabaseInformations.executeRequest(connection, "select * from table(dbms_xplan.display(null,?,null))", Collections.singletonList(statementId));
                        StringBuilder sb = new StringBuilder();
                        Object object = planTableOutput;
                        int n = ((String[][])object).length;
                        for (int i = 0; i < n; ++i) {
                            String[] row;
                            for (String value : row = object[i]) {
                                sb.append(value);
                            }
                            sb.append('\n');
                        }
                        if (sb.indexOf("-") != -1) {
                            sb.delete(0, sb.indexOf("-"));
                        }
                        object = sb.toString();
                        return object;
                    }
                    if (database != Database.POSTGRESQL || !POSTGRESQL_DRIVER_AVAILABLE || connection.getMetaData().getDatabaseMajorVersion() < 16 || (pgConnection = connection.unwrap(PgConnection.class)) == null) break block33;
                    PreferQueryMode preferQueryMode = pgConnection.getQueryExecutor().getPreferQueryMode();
                    try {
                        pgConnection.getQueryExecutor().setPreferQueryMode(PreferQueryMode.SIMPLE);
                        String explainPlanRequest = "explain (generic_plan) " + DatabaseInformations.normalizeRequestForExplain(sqlRequest, '$');
                        StringBuilder sb = new StringBuilder();
                        try (Statement statement = connection.createStatement();
                             ResultSet resultSet = statement.executeQuery(explainPlanRequest);){
                            while (resultSet.next()) {
                                sb.append(resultSet.getString(1)).append('\n');
                            }
                        }
                        string = sb.toString();
                    }
                    catch (Throwable throwable) {
                        pgConnection.getQueryExecutor().setPreferQueryMode(preferQueryMode);
                        throw throwable;
                    }
                    pgConnection.getQueryExecutor().setPreferQueryMode(preferQueryMode);
                    return string;
                }
                finally {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
            }
        }
        return null;
    }

    private static String normalizeRequestForExplain(String sqlRequest, char parameterChar) {
        int i = 1;
        Object request = sqlRequest;
        if (Parameter.SQL_TRANSFORM_PATTERN.getValue() != null) {
            request = ((String)request).replace('$', '?');
        }
        if (((String)request).indexOf(59) != -1) {
            request = ((String)request).substring(0, ((String)request).indexOf(59));
        }
        int index = ((String)request).indexOf(63);
        while (index != -1) {
            request = ((String)request).substring(0, index) + parameterChar + i + ((String)request).substring(index + 1);
            ++i;
            index = ((String)request).indexOf(63);
        }
        return request;
    }

    private static boolean isPostgresqlDriverAvailable() {
        try {
            Class.forName("org.postgresql.jdbc.PgConnection");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[database=" + this.database + "]";
    }

    static enum Database {
        POSTGRESQL("PostgreSQL"),
        MYSQL("MySQL"),
        MARIADB("MariaDB"),
        ORACLE("Oracle"),
        DB2("DB2 UDB for AS/400", "DB2/"),
        H2("H2"),
        HSQLDB("HSQL Database Engine"),
        SQLSERVER("Microsoft SQL Server"),
        SYBASE("Sybase SQL Server", "Adaptive Server Enterprise"),
        INFORMIX("Informix Dynamic Server"),
        SQLITE("SQLite");

        private static final String RESOURCE_BUNDLE_BASE_NAME;
        private final List<String> databaseNames;

        private Database(String ... databaseNames) {
            this.databaseNames = List.of(databaseNames);
        }

        List<String> getRequestNames() {
            List<String> tmp;
            switch (this) {
                case POSTGRESQL: {
                    tmp = List.of("pg_stat_activity", "pg_locks", "pg_database", "pg_tablespace", "pg_stat_database", "pg_stat_user_tables", "pg_stat_user_indexes", "pg_statio_user_tables", "pg_statio_user_indexes", "pg_statio_user_sequences", "pg_settings");
                    break;
                }
                case MYSQL: 
                case MARIADB: {
                    tmp = List.of("processlist", "databases", "variables", "global_status", "innodb_status", "unusedIndexes", "longRunning", "tableStats", "eventsWaits", "tableIoWaits", "indexIoWaits", "tableLockWaits", "tablesWithoutPk", "perfDigests", "memory");
                    break;
                }
                case ORACLE: {
                    tmp = List.of("sessions", "locks", "sqlTimes", "foreignKeysWithoutIndexes", "invalidObjects", "disabledConstraints", "tableStats", "instance", "database", "nlsParameters", "tablespaceFreespace", "datafileIo", "tablespaceExtents", "ratios", "parameters", "rollbackSegmentStatistics", "statistics", "events");
                    break;
                }
                case DB2: {
                    tmp = List.of("mon_current_sql", "mon_db_summary", "mon_lockwaits", "mon_service_subclass_summary", "mon_current_uow", "mon_workload_summary", "mon_get_connection", "current_queries");
                    break;
                }
                case H2: {
                    tmp = List.of("memory", "sessions", "locks", "settings");
                    break;
                }
                case HSQLDB: {
                    tmp = List.of("system_sessions", "system_cacheinfo", "system_properties", "system_schemas");
                    break;
                }
                case SQLSERVER: {
                    tmp = List.of("version", "connections");
                    break;
                }
                case SYBASE: {
                    tmp = List.of("sp_who", "connections", "sp_lock", "lock", "running_stored_procedure", "used_temporary_tables", "used_tables", "sp_version");
                    break;
                }
                case INFORMIX: {
                    tmp = List.of("version", "sessions", "resources_by_user", "current_queries", "config");
                    break;
                }
                case SQLITE: {
                    tmp = List.of("version", "database_list");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return this.addPrefix(tmp);
        }

        private List<String> addPrefix(List<String> requests) {
            ArrayList<String> list = new ArrayList<String>(requests.size());
            String prefix = this.toString().toLowerCase(Locale.ENGLISH) + ".";
            for (String requestName : requests) {
                list.add(prefix + requestName);
            }
            return list;
        }

        String getUrlIdentifier() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        String getRequestByName(String requestName) {
            return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME).getString(requestName);
        }

        List<String> getDatabaseNames() {
            return this.databaseNames;
        }

        private boolean isRecognized(String databaseName, String url) {
            for (String name : this.getDatabaseNames()) {
                if (!databaseName.startsWith(name)) continue;
                return true;
            }
            return url != null && url.contains(this.getUrlIdentifier());
        }

        static Database getDatabaseForConnection(Connection connection) throws SQLException {
            DatabaseMetaData metaData = connection.getMetaData();
            String databaseName = metaData.getDatabaseProductName();
            String url = metaData.getURL();
            for (Database database : Database.values()) {
                if (!database.isRecognized(databaseName, url)) continue;
                return database;
            }
            throw new IllegalArgumentException(I18N.getFormattedString("type_base_de_donnees_inconnu", databaseName));
        }

        static {
            RESOURCE_BUNDLE_BASE_NAME = Parameters.getResourcePath("databaseInformations").replace('/', '.').substring(1);
        }
    }
}

