/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.internal.common.I18N;

public class SessionInformations
implements Serializable {
    private static final long serialVersionUID = -2689338895804445093L;
    private static final List<String> BROWSERS = List.of("Edge", "Edg", "Chrome", "CriOS", "Firefox", "Safari", "MSIE", "Trident", "Opera");
    private static final List<String> OS = List.of("Windows", "Android", "Linux", "Mac OS");
    private static final Map<String, String> WINDOWS_CODE_TO_NAME_MAP = new LinkedHashMap<String, String>();
    private static final ByteArrayOutputStream TEMP_OUTPUT;
    private final String id;
    private final Date lastAccess;
    private final Date age;
    private final Date expirationDate;
    private final int attributeCount;
    private final boolean serializable;
    private final String country;
    private final String remoteAddr;
    private final String remoteUser;
    private final String userAgent;
    private final int serializedSize;
    private final List<SessionAttribute> attributes;

    public SessionInformations(HttpSession session, boolean includeAttributes) {
        assert (session != null);
        this.id = session.getId();
        long now = System.currentTimeMillis();
        this.lastAccess = new Date(now - session.getLastAccessedTime());
        this.age = new Date(now - session.getCreationTime());
        this.expirationDate = new Date(session.getLastAccessedTime() + (long)session.getMaxInactiveInterval() * 1000L);
        ArrayList<String> attributeNames = Collections.list(session.getAttributeNames());
        this.attributeCount = attributeNames.size();
        this.serializable = this.computeSerializable(session, attributeNames);
        Object countryCode = session.getAttribute("javamelody.country");
        this.country = countryCode == null ? null : countryCode.toString().toLowerCase(Locale.ENGLISH);
        Object addr = session.getAttribute("javamelody.remoteAddr");
        this.remoteAddr = addr == null ? null : addr.toString();
        Object user = session.getAttribute("javamelody.remoteUser");
        if (user == null && (user = session.getAttribute("ACEGI_SECURITY_LAST_USERNAME")) == null) {
            user = session.getAttribute("SPRING_SECURITY_LAST_USERNAME");
        }
        this.remoteUser = user == null ? null : user.toString();
        Object agent = session.getAttribute("javamelody.userAgent");
        this.userAgent = agent == null ? null : agent.toString();
        this.serializedSize = this.computeSerializedSize(session, attributeNames);
        if (includeAttributes) {
            this.attributes = new ArrayList<SessionAttribute>(this.attributeCount);
            for (String attributeName : attributeNames) {
                this.attributes.add(new SessionAttribute(session, attributeName));
            }
        } else {
            this.attributes = null;
        }
    }

    private boolean computeSerializable(HttpSession session, List<String> attributeNames) {
        for (String attributeName : attributeNames) {
            Object attributeValue = session.getAttribute(attributeName);
            if (attributeValue == null || attributeValue instanceof Serializable) continue;
            return false;
        }
        return true;
    }

    private int computeSerializedSize(HttpSession session, List<String> attributeNames) {
        if (!this.serializable) {
            return -1;
        }
        ArrayList<Serializable> serializableAttributes = new ArrayList<Serializable>(attributeNames.size());
        for (String attributeName : attributeNames) {
            Object attributeValue = session.getAttribute(attributeName);
            serializableAttributes.add((Serializable)attributeValue);
        }
        return SessionInformations.getObjectSize(serializableAttributes);
    }

    public String getId() {
        return this.id;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public Date getAge() {
        return this.age;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public String getCountry() {
        return this.country;
    }

    public String getCountryDisplay() {
        String myCountry = this.getCountry();
        if (myCountry == null) {
            return null;
        }
        return new Locale("fr", myCountry).getDisplayCountry(I18N.getCurrentLocale());
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getBrowser() {
        if (this.userAgent == null) {
            return null;
        }
        String[] userAgentSplitted = this.userAgent.split("[ ;]");
        for (String browser : BROWSERS) {
            for (String ua : userAgentSplitted) {
                if (!ua.contains(browser)) continue;
                String result = ua.trim();
                return result.replace("Trident/7.0", "MSIE 11.0");
            }
        }
        return null;
    }

    public String getOs() {
        if (this.userAgent == null) {
            return null;
        }
        String[] userAgentSplitted = this.userAgent.split("[();]");
        for (String os : OS) {
            for (String ua : userAgentSplitted) {
                if (!ua.contains(os)) continue;
                String result = ua.trim();
                if (result.contains("Windows")) {
                    for (Map.Entry<String, String> entry : WINDOWS_CODE_TO_NAME_MAP.entrySet()) {
                        String code = entry.getKey();
                        String name = entry.getValue();
                        result = result.replace(code, name);
                    }
                }
                return result;
            }
        }
        return null;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    public List<SessionAttribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", remoteAddr=" + this.getRemoteAddr() + ", serializedSize=" + this.getSerializedSize() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getObjectSize(Object object) {
        if (!(object instanceof Serializable)) {
            return -1;
        }
        Serializable serializable = (Serializable)object;
        ByteArrayOutputStream byteArrayOutputStream = TEMP_OUTPUT;
        synchronized (byteArrayOutputStream) {
            TEMP_OUTPUT.reset();
            try {
                try (ObjectOutputStream out = new ObjectOutputStream(TEMP_OUTPUT);){
                    out.writeObject(serializable);
                }
                return TEMP_OUTPUT.size();
            }
            catch (Throwable e) {
                return -1;
            }
        }
    }

    static {
        WINDOWS_CODE_TO_NAME_MAP.put("NT 6.3", "8.1");
        WINDOWS_CODE_TO_NAME_MAP.put("NT 6.2", "8");
        WINDOWS_CODE_TO_NAME_MAP.put("NT 6.1", "7");
        WINDOWS_CODE_TO_NAME_MAP.put("NT 6.0", "Vista");
        WINDOWS_CODE_TO_NAME_MAP.put("NT 5.2", "Server 2003/XP");
        WINDOWS_CODE_TO_NAME_MAP.put("NT 5.1", "XP");
        TEMP_OUTPUT = new ByteArrayOutputStream(8192);
    }

    public static class SessionAttribute
    implements Serializable {
        private static final long serialVersionUID = 4786854834871331127L;
        private final String name;
        private final String type;
        private final String content;
        private final boolean serializable;
        private final int serializedSize;

        SessionAttribute(HttpSession session, String attributeName) {
            assert (session != null);
            assert (attributeName != null);
            this.name = attributeName;
            Object value = session.getAttribute(attributeName);
            this.serializable = value == null || value instanceof Serializable;
            this.serializedSize = SessionInformations.getObjectSize(value);
            if (value == null) {
                this.content = null;
                this.type = null;
            } else {
                String tmp;
                try {
                    tmp = String.valueOf(value);
                }
                catch (Exception e) {
                    tmp = e.toString();
                }
                this.content = tmp;
                this.type = value.getClass().getName();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isSerializable() {
            return this.serializable;
        }

        public int getSerializedSize() {
            return this.serializedSize;
        }
    }
}

