/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.internal.UploadPartRequestFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.bull.javamelody.internal.common.LOG;

final class S3 {
    private static final long MINIMUM_SIZE_FOR_MULTIPART = 314572800L;
    private static final long PART_SIZE = 0xC800000L;

    private S3() {
    }

    static void upload(File file, String bucketName) throws IOException {
        AmazonS3 s3Client = AmazonS3ClientBuilder.defaultClient();
        if (file.length() > 314572800L) {
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            InitiateMultipartUploadResult initResponse = s3Client.initiateMultipartUpload(new InitiateMultipartUploadRequest(bucketName, file.getName()));
            String uploadId = initResponse.getUploadId();
            UploadPartRequestFactory requestFactory = new UploadPartRequestFactory(new PutObjectRequest(bucketName, file.getName(), file), uploadId, 0xC800000L);
            try {
                while (requestFactory.hasMoreRequests()) {
                    partETags.add(s3Client.uploadPart(requestFactory.getNextUploadPartRequest()).getPartETag());
                }
                CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(bucketName, file.getName(), uploadId, partETags);
                s3Client.completeMultipartUpload(compRequest);
            }
            catch (Exception e) {
                s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, file.getName(), uploadId));
                throw new IOException(e);
            }
        }
        try {
            s3Client.putObject(bucketName, file.getName(), file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        LOG.info("File " + file.getName() + " uploaded successfully to S3");
    }
}

