/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import net.bull.javamelody.JpaPersistence;
import net.bull.javamelody.internal.common.InputOutput;

class JpaOverridePersistenceXmlClassLoader
extends ClassLoader {
    private static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final String PERSISTENCE_PROVIDER = JpaPersistence.class.getName();
    private static final String NO_PROVIDER = "<provider></provider>";
    private final String replacement;

    JpaOverridePersistenceXmlClassLoader(ClassLoader parent, String replacement) {
        super(parent);
        this.replacement = replacement;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (PERSISTENCE_XML.equals(name) && url != null) {
            return this.newUrl(url, JpaOverridePersistenceXmlClassLoader.slurp(url));
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = super.getResources(name);
        if (PERSISTENCE_XML.equals(name)) {
            LinkedList<URL> overrided = new LinkedList<URL>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                overrided.add(this.newUrl(url, JpaOverridePersistenceXmlClassLoader.slurp(url)));
            }
            return Collections.enumeration(overrided);
        }
        return urls;
    }

    private URL newUrl(URL url, String slurp) {
        if (slurp.contains(PERSISTENCE_PROVIDER)) {
            String afterReplace = slurp.replace(PERSISTENCE_PROVIDER, this.replacement).replace(NO_PROVIDER, "");
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), new ConstantURLStreamHandler(afterReplace));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return url;
    }

    private static String slurp(URL url) {
        String string;
        block8: {
            InputStream is = url.openStream();
            try {
                string = InputOutput.pumpToString(is, Charset.defaultCharset());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            is.close();
        }
        return string;
    }

    private static class ConstantURLStreamHandler
    extends URLStreamHandler {
        private final String value;

        ConstantURLStreamHandler(String value) {
            this.value = value;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new ConstantURLConnection(u, this.value);
        }
    }

    private static class ConstantURLConnection
    extends URLConnection {
        private final String value;

        ConstantURLConnection(URL url, String value) {
            super(url);
            this.value = value;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.value.getBytes());
        }
    }
}

