/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.monitoring;

import hudson.model.Action;
import hudson.model.Computer;
import jakarta.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import org.jvnet.hudson.plugins.monitoring.SystemReadPermission;
import org.kohsuke.stapler.Stapler;

public class NodeMonitoringAction
implements Action {
    private final Computer computer;
    private final String displayName;
    private final String iconPath;

    public NodeMonitoringAction(Computer computer, String displayName, String iconPath) {
        this.computer = computer;
        this.displayName = displayName;
        this.iconPath = iconPath;
    }

    public Computer getComputer() {
        return this.computer;
    }

    public final String getDisplayName() {
        return this.hasMonitoringPermissions() && this.computer.isOnline() ? this.displayName : null;
    }

    public final String getIconFileName() {
        return this.hasMonitoringPermissions() && this.computer.isOnline() ? this.iconPath : null;
    }

    public String getUrlName() {
        return "monitoring";
    }

    public String getMonitoringUrl() {
        String urlSuffix = this.computer instanceof Jenkins.MasterComputer ? "" : "/nodes/" + this.computer.getName();
        return "../../../../monitoring" + urlSuffix;
    }

    public String getCsrfTokenUrlPart() {
        try {
            SessionListener.bindSession((HttpSession)Stapler.getCurrentRequest2().getSession(false));
            String string = HtmlAbstractReport.getCsrfTokenUrlPart().replace("&amp;", "&");
            return string;
        }
        finally {
            SessionListener.unbindSession();
        }
    }

    protected boolean hasMonitoringPermissions() {
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins.hasPermission(Jenkins.ADMINISTER) || SystemReadPermission.SYSTEM_READ != null && jenkins.hasPermission(SystemReadPermission.SYSTEM_READ);
    }
}

