/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdBackend;

public class RrdMemoryBackend
extends RrdBackend {
    private byte[] buffer = new byte[0];

    protected RrdMemoryBackend(String path) {
        super(path);
    }

    protected synchronized void write(long offset, byte[] b) throws IOException {
        int pos = (int)offset;
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte singleByte = byArray[n2];
            this.buffer[pos++] = singleByte;
            ++n2;
        }
    }

    protected synchronized void read(long offset, byte[] b) throws IOException {
        int pos = (int)offset;
        if (pos + b.length <= this.buffer.length) {
            int i = 0;
            while (i < b.length) {
                b[i] = this.buffer[pos++];
                ++i;
            }
        } else {
            throw new IOException("Not enough bytes available in memory " + this.getPath());
        }
    }

    public long getLength() {
        return this.buffer.length;
    }

    protected void setLength(long newLength) throws IOException {
        if (newLength > Integer.MAX_VALUE) {
            throw new IOException("Cannot create this big memory backed RRD");
        }
        this.buffer = new byte[(int)newLength];
    }

    public void close() {
    }

    protected boolean isCachingAllowed() {
        return false;
    }
}

