/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.JobInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlJavaInformationsReport;

class HtmlJobInformationsReport
extends HtmlAbstractReport {
    private static final long ONE_DAY_MILLIS = 86400000L;
    private final List<JobInformations> jobInformationsList;
    private final Counter jobCounter;
    private final DateFormat fireTimeFormat = I18N.createDateAndTimeFormat();
    private final DateFormat durationFormat = I18N.createDurationFormat();
    private final boolean systemActionsEnabled = Parameters.isSystemActionsEnabled();

    HtmlJobInformationsReport(List<JobInformations> jobInformationsList, Counter rangeJobCounter, Writer writer) {
        super(writer);
        assert (jobInformationsList != null);
        assert (rangeJobCounter != null);
        this.jobInformationsList = jobInformationsList;
        this.jobCounter = rangeJobCounter;
    }

    @Override
    void toHtml() throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlJobInformationsReport.getString("Jobs"));
        this.write("<th>#JobGroup#</th>");
        this.write("<th>#JobName#</th>");
        this.write("<th>#JobClassName#</th>");
        this.write("<th>#JobLastException#</th>");
        this.write("<th class='sorttable_date'>#JobMeanTime#</th>");
        this.write("<th class='sorttable_date'>#JobElapsedTime#</th>");
        this.write("<th class='sorttable_date'>#JobPreviousFireTime#</th>");
        this.write("<th class='sorttable_date'>#JobNextFireTime#</th>");
        this.write("<th>#JobPeriodOrCronExpression#</th>");
        this.write("<th>#JobPaused#</th>");
        if (this.systemActionsEnabled) {
            this.write("<th class='noPrint'>#Pause_job#</th>");
            this.write("<th class='noPrint'>#Resume_job#</th>");
        }
        for (JobInformations jobInformations : this.jobInformationsList) {
            table.nextRow();
            this.writeJobInformations(jobInformations);
        }
        table.endTable();
        this.write("<div align='right' class='noPrint'>");
        if (this.systemActionsEnabled) {
            String onClickConfirm = "' class='confirm' data-confirm='";
            String endOnClickConfirm = "'>";
            this.writeln("<a href='?action=pause_job&amp;jobId=all" + HtmlJobInformationsReport.getCsrfTokenUrlPart() + "' class='confirm' data-confirm='" + HtmlJobInformationsReport.htmlEncodeButNotSpaceAndNewLine(HtmlJobInformationsReport.getString("confirm_pause_all_jobs")) + "'>");
            this.writeln("<img src='?resource=control_pause_blue.png' width='18' height='18' alt=\"#Pause_all_jobs#\" /> #Pause_all_jobs#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?action=resume_job&amp;jobId=all" + HtmlJobInformationsReport.getCsrfTokenUrlPart() + "' class='confirm' data-confirm='" + HtmlJobInformationsReport.htmlEncodeButNotSpaceAndNewLine(HtmlJobInformationsReport.getString("confirm_resume_all_jobs")) + "'>");
            this.writeln("<img src='?resource=control_play_blue.png' width='18' height='18' alt=\"#Resume_all_jobs#\" /> #Resume_all_jobs#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writeDirectly("<a href='http://www.quartz-scheduler.org/documentation/'");
        this.writeln("target='_blank'>Configuration reference</a>");
        this.writeln("</div>");
    }

    private void writeJobInformations(JobInformations jobInformations) throws IOException {
        this.write("<td>");
        String nextColumnAlignRight = "</td> <td align='right'>";
        this.writeDirectly(HtmlJobInformationsReport.htmlEncodeButNotSpace(jobInformations.getGroup()));
        this.write("</td> <td>");
        this.writeNameWithDescription(jobInformations);
        this.write("</td> <td>");
        this.writeDirectly(HtmlJobInformationsReport.htmlEncodeButNotSpace(jobInformations.getJobClassName()));
        CounterRequest counterRequest = this.getCounterRequest(jobInformations);
        this.write("</td> <td align='center'>");
        this.writeStackTrace(counterRequest.getStackTrace());
        if (counterRequest.getMean() >= 0) {
            this.write("</td> <td align='right'>");
            this.write(this.formatDuration(counterRequest.getMean()));
        } else {
            this.write("</td><td>&nbsp;");
        }
        this.writeJobTimes(jobInformations, counterRequest);
        this.write("</td> <td align='center'>");
        if (jobInformations.isPaused()) {
            this.write("#oui#");
        } else {
            this.write("#non#");
        }
        if (this.systemActionsEnabled) {
            this.writePauseJobAndResumeJobLinks(jobInformations);
        }
        this.write("</td>");
    }

    private String formatDuration(int durationAsMillis) {
        long duration = 1L * (long)durationAsMillis;
        return this.durationFormat.format(new Date(duration));
    }

    private void writeNameWithDescription(JobInformations jobInformations) throws IOException {
        if (jobInformations.getDescription() == null) {
            this.writeDirectly(HtmlJobInformationsReport.htmlEncodeButNotSpace(jobInformations.getName()));
        } else {
            this.write("<a class='tooltip'><em>");
            this.writeDirectly(HtmlJobInformationsReport.htmlEncodeButNotSpace(jobInformations.getDescription()));
            this.writeln("</em>");
            this.writeDirectly(HtmlJobInformationsReport.htmlEncodeButNotSpace(jobInformations.getName()));
            this.writeln("</a>");
        }
    }

    private void writeStackTrace(String stackTrace) throws IOException {
        if (stackTrace == null) {
            this.write("<img src='?resource=bullets/green.png' alt='#JobWithoutLastException#' title='#JobWithoutLastException#'/>");
        } else {
            this.write("<a class='tooltip'>");
            this.write("<em>");
            this.writeDirectly(HtmlJobInformationsReport.htmlEncode(stackTrace.replace("[See nested", "\n[See nested")));
            this.writeln("");
            this.writeln("</em>");
            this.write("<img src='?resource=bullets/red.png' alt=''/>");
            this.writeln("</a>");
        }
    }

    private void writeJobTimes(JobInformations jobInformations, CounterRequest counterRequest) throws IOException {
        String nextColumnAlignRight = "</td> <td align='right'>";
        String nbsp = "&nbsp;";
        this.write("</td> <td align='right'>");
        if (jobInformations.getElapsedTime() >= 0L) {
            this.write(this.durationFormat.format(new Date(jobInformations.getElapsedTime())));
            this.write("<br/>");
            this.writeln(HtmlJobInformationsReport.toBar(counterRequest.getMean(), jobInformations.getElapsedTime()));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='right'>");
        if (jobInformations.getPreviousFireTime() != null) {
            this.write(this.fireTimeFormat.format(jobInformations.getPreviousFireTime()));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='right'>");
        if (jobInformations.getNextFireTime() != null) {
            this.write(this.fireTimeFormat.format(jobInformations.getNextFireTime()));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='right'>");
        if (jobInformations.getRepeatInterval() > 0L && jobInformations.getRepeatInterval() < 86400000L) {
            this.write(this.durationFormat.format(new Date(jobInformations.getRepeatInterval())));
        } else if (jobInformations.getCronExpression() != null) {
            this.writeDirectly(HtmlJobInformationsReport.htmlEncodeButNotSpace(jobInformations.getCronExpression()));
        } else {
            this.write("&nbsp;");
        }
    }

    private void writePauseJobAndResumeJobLinks(JobInformations jobInformations) throws IOException {
        this.write("</td> <td align='center' class='noPrint'>");
        String onClickConfirm = "' class='confirm' data-confirm='";
        String endOnClickConfirm = "'>";
        this.writeln("<a href='?action=pause_job&amp;jobId=" + jobInformations.getGlobalJobId() + HtmlJobInformationsReport.getCsrfTokenUrlPart() + "' class='confirm' data-confirm='" + HtmlJobInformationsReport.htmlEncodeButNotSpaceAndNewLine(HtmlJobInformationsReport.getString("confirm_pause_job")) + "'>");
        this.writeln("<img src='?resource=control_pause_blue.png' width='18' height='18' alt=\"#Pause_job#\" title=\"#Pause_job#\" /></a>");
        this.write("</td> <td align='center' class='noPrint'>");
        this.writeln("<a href='?action=resume_job&amp;jobId=" + jobInformations.getGlobalJobId() + HtmlJobInformationsReport.getCsrfTokenUrlPart() + "' class='confirm' data-confirm='" + HtmlJobInformationsReport.htmlEncodeButNotSpaceAndNewLine(HtmlJobInformationsReport.getString("confirm_resume_job")) + "'>");
        this.writeln("<img src='?resource=control_play_blue.png' width='18' height='18' alt=\"#Resume_job#\" title=\"#Resume_job#\" /></a>");
    }

    private CounterRequest getCounterRequest(JobInformations jobInformations) {
        String jobFullName = jobInformations.getGroup() + '.' + jobInformations.getName();
        CounterRequest result = this.jobCounter.getCounterRequestByName(jobFullName, true);
        assert (result != null);
        return result;
    }

    private static String toBar(int mean, long elapsedTime) {
        return HtmlJavaInformationsReport.toBar(100.0 * (double)elapsedTime / (double)mean);
    }
}

