/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.common;

import javax.servlet.http.HttpServletRequest;
import net.bull.javamelody.internal.common.HttpParameter;

public enum HttpPart {
    HEAP_HISTO("heaphisto"),
    PROCESSES("processes"),
    CURRENT_REQUESTS("currentRequests"),
    DEFAULT_WITH_CURRENT_REQUESTS("defaultWithCurrentRequests"),
    WEB_XML("web.xml"),
    POM_XML("pom.xml"),
    JNLP("jnlp"),
    JVM("jvm"),
    SESSIONS("sessions"),
    HOTSPOTS("hotspots"),
    DATABASE("database"),
    CONNECTIONS("connections"),
    GRAPH("graph"),
    LAST_VALUE("lastValue"),
    USAGES("usages"),
    JNDI("jndi"),
    MBEANS("mbeans"),
    CRASHES("crashes"),
    THREADS("threads"),
    THREADS_DUMP("threadsDump"),
    COUNTER_SUMMARY_PER_CLASS("counterSummaryPerClass"),
    RUNTIME_DEPENDENCIES("runtimeDependencies"),
    JROBINS("jrobins"),
    OTHER_JROBINS("otherJRobins"),
    EXPLAIN_PLAN("explainPlan"),
    APPLICATIONS("applications"),
    SOURCE("source"),
    DEPENDENCIES("dependencies"),
    SPRING_BEANS("springBeans"),
    RUM("rum"),
    WEBAPP_VERSIONS("webappVersions"),
    CACHE_KEYS("cacheKeys"),
    JCACHE_KEYS("jcacheKeys"),
    HASH_PASSWORD("hashPassword");

    private final String name;

    private HttpPart(String name) {
        this.name = name;
    }

    public boolean isPart(HttpServletRequest request) {
        return this.name.equals(HttpParameter.PART.getParameterFrom(request));
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static HttpPart getByName(String name) {
        for (HttpPart httpPart : HttpPart.values()) {
            if (!httpPart.name.equals(name)) continue;
            return httpPart;
        }
        throw new IllegalArgumentException("Unknown part: " + name);
    }
}

