/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.SortedSet;
import java.util.TreeSet;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.MessageDigestPasswordEncoder;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

class HtmlHashPasswordReport
extends HtmlAbstractReport {
    HtmlHashPasswordReport(Writer writer) {
        super(writer);
    }

    @Override
    void toHtml() throws IOException {
        throw new UnsupportedOperationException();
    }

    void writeHashPassword(String algorithm, String password) throws IOException {
        this.writeln("<h1>Hash a password for the authorized-users parameter</h1>");
        if (algorithm != null && password != null) {
            this.write("<label for='hash'>Hash:</label> ");
            String hash = this.encodePassword(algorithm, password);
            this.writeln("<input type='text' id='hash' value='" + hash + "' size='80' />");
            this.writeln("<button class='copyHash'>Copy</button>");
            this.writeln("<br/><br/>");
        }
        this.writeln("<form class='hash' action='' method='post'>");
        this.writeln("<label for='algorithm'>Algorithm:</label>");
        this.writeln("<select name='" + HttpParameter.ALGORITHM.getName() + "' id='algorithm' required>");
        for (String algo : this.getSortedAlgorithms()) {
            if (algorithm != null && algo.equals(algorithm) || algorithm == null && "SHA-256".equals(algo)) {
                this.writeln("<option selected>" + algo + "</option>");
                continue;
            }
            this.writeln("<option>" + algo + "</option>");
        }
        this.writeln("</select>");
        this.writeln("<br/><br/>");
        this.writeln("<label for='password'>Password:</label>");
        this.writeln("<input type='password' name='" + HttpParameter.REQUEST.getName() + "' id='password' required />");
        this.writeln("<br/><br/>");
        this.writeln("<input type='submit'/>");
        this.writeln("</form>");
        this.writeln("<br/>Note that you can also hash a password using the command line: <code>java -cp javamelody-core-" + Parameters.JAVAMELODY_VERSION + ".jar net.bull.javamelody.internal.common.MessageDigestPasswordEncoder passwordToHash</code>");
    }

    private SortedSet<String> getSortedAlgorithms() {
        return new TreeSet<String>(Security.getAlgorithms("MessageDigest"));
    }

    private String encodePassword(String algorithm, String password) throws IOException {
        try {
            return new MessageDigestPasswordEncoder(algorithm).encodePassword(password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }
}

