/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.NodesCollector;
import net.bull.javamelody.RemoteCallHelper;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.HttpPart;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.model.TransportFormat;
import net.bull.javamelody.internal.web.HtmlController;
import net.bull.javamelody.internal.web.HttpCookieManager;
import net.bull.javamelody.internal.web.MonitoringController;
import net.bull.javamelody.internal.web.SerializableController;
import net.bull.javamelody.internal.web.html.HtmlReport;
import net.bull.javamelody.internal.web.pdf.PdfOtherReport;

public class NodesController {
    public static final String SESSION_REMOTE_USER = "javamelody.remoteUser";
    private final Collector collector;
    private final String nodeName;
    private final List<JavaInformations> lastJavaInformationsList;
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();

    public NodesController(NodesCollector nodesCollector, String nodeName) {
        this.collector = nodesCollector.getCollector();
        this.nodeName = nodeName;
        this.lastJavaInformationsList = nodeName == null ? new ArrayList<JavaInformations>(nodesCollector.getLastJavaInformationsList().values()) : Collections.singletonList(nodesCollector.getLastJavaInformationsList().get(nodeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMonitoring(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (this.lastJavaInformationsList != null && !this.lastJavaInformationsList.isEmpty()) {
            try {
                I18N.bindLocale((Locale)req.getLocale());
                MonitoringController monitoringController = new MonitoringController(this.collector, null);
                String partParameter = HttpParameter.PART.getParameterFrom(req);
                String actionParameter = HttpParameter.ACTION.getParameterFrom(req);
                if (actionParameter != null) {
                    String messageForReport;
                    Action action = Action.valueOfIgnoreCase((String)actionParameter);
                    if (action != Action.CLEAR_COUNTER && action != Action.PURGE_OBSOLETE_FILES && action != Action.LOGOUT) {
                        String actionName = HttpParameter.ACTION.getParameterFrom(req);
                        String sessionId = HttpParameter.SESSION_ID.getParameterFrom(req);
                        String threadId = HttpParameter.THREAD_ID.getParameterFrom(req);
                        String jobId = HttpParameter.JOB_ID.getParameterFrom(req);
                        String cacheId = HttpParameter.CACHE_ID.getParameterFrom(req);
                        messageForReport = this.getRemoteCallHelper().forwardAction(actionName, sessionId, threadId, jobId, cacheId);
                    } else {
                        messageForReport = monitoringController.executeActionIfNeeded(req);
                    }
                    if (TransportFormat.isATransportFormat((String)HttpParameter.FORMAT.getParameterFrom(req))) {
                        SerializableController serializableController = new SerializableController(this.collector);
                        Range range = serializableController.getRangeForSerializable(req);
                        ArrayList<JavaInformations> javaInformationsList = new ArrayList<JavaInformations>(this.getRemoteCallHelper().collectJavaInformationsListByName().values());
                        Serializable serializable = serializableController.createDefaultSerializable(javaInformationsList, range, messageForReport);
                        monitoringController.doCompressedSerializable(req, resp, serializable);
                    } else {
                        this.writeMessage(resp, messageForReport, partParameter);
                    }
                    return;
                }
                String formatParameter = HttpParameter.FORMAT.getParameterFrom(req);
                if (HttpParameter.JMX_VALUE.getParameterFrom(req) != null) {
                    List<String> jmxValues = this.getRemoteCallHelper().collectJmxValues(HttpParameter.JMX_VALUE.getParameterFrom(req));
                    this.doJmxValue(resp, jmxValues);
                }
                if (TransportFormat.isATransportFormat((String)HttpParameter.FORMAT.getParameterFrom(req))) {
                    this.doCompressedSerializable(req, resp, monitoringController);
                }
                if ("pdf".equalsIgnoreCase(formatParameter)) {
                    this.doPdf(req, resp, monitoringController);
                }
                if (partParameter == null) {
                    monitoringController.doReport(req, resp, this.lastJavaInformationsList);
                }
                this.doPart(req, resp, monitoringController);
            }
            catch (Throwable e) {
                this.writeMessage(resp, e.getMessage(), null);
            }
            finally {
                I18N.unbindLocale();
            }
        } else {
            MonitoringController.noCache((HttpServletResponse)resp);
            PrintWriter writer = resp.getWriter();
            writer.write("<html><body>");
            writer.write("<a href='javascript:history.back()'>Back</a>");
            writer.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            writer.write("<a href='?'>Update</a>");
            writer.write("<br/><br/>No slaves online, try again in a minute.");
            writer.write("</body></html>");
            writer.close();
        }
    }

    private void writeMessage(HttpServletResponse resp, String message, String partToRedirectTo) throws IOException {
        MonitoringController.noCache((HttpServletResponse)resp);
        PrintWriter writer = NodesController.createWriterFromOutputStream(resp);
        new HtmlReport(this.collector, null, this.lastJavaInformationsList, Period.TOUT, (Writer)writer).writeMessageIfNotNull(message, partToRedirectTo);
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPdf(HttpServletRequest req, HttpServletResponse resp, MonitoringController monitoringController) throws IOException, ServletException {
        if (HttpPart.PROCESSES.isPart(req)) {
            monitoringController.addPdfContentTypeAndDisposition(req, resp);
            Map<String, List<ProcessInformations>> processInformationsByNodeName = this.getRemoteCallHelper().collectProcessInformationsByNodeName();
            try {
                this.doPdfProcesses(resp, processInformationsByNodeName);
            }
            finally {
                resp.getOutputStream().flush();
            }
        } else if (HttpPart.MBEANS.isPart(req)) {
            monitoringController.addPdfContentTypeAndDisposition(req, resp);
            Map<String, List<MBeanNode>> mbeanNodesByNodeName = this.getRemoteCallHelper().collectMBeanNodesByNodeName();
            try {
                this.doPdfMBeans(resp, mbeanNodesByNodeName);
            }
            finally {
                resp.getOutputStream().flush();
            }
        } else {
            monitoringController.doReport(req, resp, this.lastJavaInformationsList);
        }
    }

    private void doPdfProcesses(HttpServletResponse resp, Map<String, List<ProcessInformations>> processInformationsByNodeName) throws IOException {
        String title = I18N.getString((String)"Processus");
        Map<String, List<ProcessInformations>> processInformationsByTitle = this.convertMapByNodeToMapByTitle(processInformationsByNodeName, title);
        new PdfOtherReport(this.collector.getApplication(), (OutputStream)resp.getOutputStream()).writeProcessInformations(processInformationsByTitle);
    }

    private void doPdfMBeans(HttpServletResponse resp, Map<String, List<MBeanNode>> mbeanNodesByNodeName) throws IOException {
        String title = I18N.getString((String)"MBeans");
        Map<String, List<MBeanNode>> mbeanNodesByTitle = this.convertMapByNodeToMapByTitle(mbeanNodesByNodeName, title);
        new PdfOtherReport(this.collector.getApplication(), (OutputStream)resp.getOutputStream()).writeMBeans(mbeanNodesByTitle);
    }

    private void doJmxValue(HttpServletResponse resp, List<String> jmxValues) throws IOException {
        MonitoringController.noCache((HttpServletResponse)resp);
        resp.setContentType("text/plain");
        PrintWriter writer = resp.getWriter();
        boolean first = true;
        for (String jmxValue : jmxValues) {
            if (first) {
                first = false;
            } else {
                writer.write(124);
                writer.write(124);
            }
            writer.write(jmxValue);
        }
        writer.close();
    }

    private void doPart(HttpServletRequest req, HttpServletResponse resp, MonitoringController monitoringController) throws IOException, ServletException {
        if (HttpPart.MBEANS.isPart(req)) {
            Map<String, List<MBeanNode>> mbeanNodesByNodeName = this.getRemoteCallHelper().collectMBeanNodesByNodeName();
            this.doMBeans(req, resp, mbeanNodesByNodeName);
        } else if (HttpPart.PROCESSES.isPart(req)) {
            Map<String, List<ProcessInformations>> processInformationsByNodeName = this.getRemoteCallHelper().collectProcessInformationsByNodeName();
            this.doProcesses(req, resp, processInformationsByNodeName);
        } else if (HttpPart.HEAP_HISTO.isPart(req)) {
            HeapHistogram heapHistoTotal = this.getRemoteCallHelper().collectGlobalHeapHistogram();
            this.doHeapHisto(req, resp, heapHistoTotal, monitoringController);
        } else {
            monitoringController.doReport(req, resp, this.lastJavaInformationsList);
        }
    }

    private void doProcesses(HttpServletRequest req, HttpServletResponse resp, Map<String, List<ProcessInformations>> processListByNodeName) throws IOException {
        PrintWriter writer = NodesController.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer);
        String title = I18N.getString((String)"Processus");
        Map<String, List<ProcessInformations>> processListByTitle = this.convertMapByNodeToMapByTitle(processListByNodeName, title);
        htmlReport.writeProcesses(processListByTitle);
        writer.close();
    }

    private void doMBeans(HttpServletRequest req, HttpServletResponse resp, Map<String, List<MBeanNode>> mbeanNodesByNodeName) throws IOException {
        PrintWriter writer = NodesController.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer);
        String title = I18N.getString((String)"MBeans");
        Map<String, List<MBeanNode>> mbeanNodesByTitle = this.convertMapByNodeToMapByTitle(mbeanNodesByNodeName, title);
        htmlReport.writeMBeans(mbeanNodesByTitle);
        writer.close();
    }

    private <T> Map<String, T> convertMapByNodeToMapByTitle(Map<String, T> mapByNodeName, String title) {
        LinkedHashMap<Object, T> mapByTitle = new LinkedHashMap<Object, T>(mapByNodeName.size());
        for (Map.Entry<String, T> entry : mapByNodeName.entrySet()) {
            String name = entry.getKey();
            if (name != null && name.length() != 0) {
                mapByTitle.put(title + " (" + entry.getKey() + ")", entry.getValue());
                continue;
            }
            mapByTitle.put(title, entry.getValue());
        }
        return mapByTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHeapHisto(HttpServletRequest req, HttpServletResponse resp, HeapHistogram heapHistogram, MonitoringController monitoringController) throws IOException {
        if ("pdf".equalsIgnoreCase(HttpParameter.FORMAT.getParameterFrom(req))) {
            monitoringController.addPdfContentTypeAndDisposition(req, resp);
            try {
                PdfOtherReport pdfOtherReport = new PdfOtherReport(this.collector.getApplication(), (OutputStream)resp.getOutputStream());
                pdfOtherReport.writeHeapHistogram(heapHistogram);
            }
            finally {
                resp.getOutputStream().flush();
            }
        } else {
            PrintWriter writer = NodesController.createWriterFromOutputStream(resp);
            HtmlReport htmlReport = this.createHtmlReport(req, resp, writer);
            htmlReport.writeHtmlHeader();
            htmlReport.writeHeapHistogram(heapHistogram, null, HttpPart.HEAP_HISTO.getName());
            htmlReport.writeHtmlFooter();
            writer.close();
        }
    }

    private void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, MonitoringController monitoringController) throws IOException {
        Serializable serializable;
        try {
            serializable = this.createSerializable(httpRequest);
        }
        catch (Exception e) {
            serializable = e;
        }
        monitoringController.doCompressedSerializable(httpRequest, httpResponse, serializable);
    }

    private Serializable createSerializable(HttpServletRequest httpRequest) throws Exception {
        if (HttpPart.MBEANS.isPart(httpRequest)) {
            return new LinkedHashMap<String, List<MBeanNode>>(this.getRemoteCallHelper().collectMBeanNodesByNodeName());
        }
        if (HttpPart.PROCESSES.isPart(httpRequest)) {
            return new LinkedHashMap<String, List<ProcessInformations>>(this.getRemoteCallHelper().collectProcessInformationsByNodeName());
        }
        if (HttpPart.HEAP_HISTO.isPart(httpRequest)) {
            return this.getRemoteCallHelper().collectGlobalHeapHistogram();
        }
        if (HttpPart.JVM.isPart(httpRequest)) {
            return new ArrayList<JavaInformations>(this.lastJavaInformationsList);
        }
        if (HttpPart.THREADS.isPart(httpRequest)) {
            ArrayList result = new ArrayList();
            for (JavaInformations javaInformations : this.lastJavaInformationsList) {
                result.add(new ArrayList(javaInformations.getThreadInformationsList()));
            }
            return result;
        }
        SerializableController serializableController = new SerializableController(this.collector);
        return serializableController.createSerializable(httpRequest, this.lastJavaInformationsList, null);
    }

    private HtmlReport createHtmlReport(HttpServletRequest req, HttpServletResponse resp, PrintWriter writer) {
        Range range = this.httpCookieManager.getRange(req, resp);
        return new HtmlReport(this.collector, null, this.lastJavaInformationsList, range, (Writer)writer);
    }

    private static PrintWriter createWriterFromOutputStream(HttpServletResponse httpResponse) throws IOException {
        MonitoringController.noCache((HttpServletResponse)httpResponse);
        httpResponse.setContentType("text/html; charset=UTF-8");
        return new PrintWriter(HtmlController.getWriter((HttpServletResponse)httpResponse));
    }

    private RemoteCallHelper getRemoteCallHelper() {
        return new RemoteCallHelper(this.nodeName);
    }

    public static boolean isJavaInformationsNeeded(HttpServletRequest httpRequest) {
        return MonitoringController.isJavaInformationsNeeded((HttpServletRequest)httpRequest);
    }
}

