/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import net.bull.javamelody.MonitoredWithSpring;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;

public class MonitoringSpringInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = -6594338383847482623L;
    private static final Counter SPRING_COUNTER = MonitoringProxy.getSpringCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(SPRING_COUNTER.getName());
    private static final boolean DISABLED = Parameter.DISABLED.getValueAsBoolean();

    public MonitoringSpringInterceptor() {
        SPRING_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        SPRING_COUNTER.setUsed(true);
        LOG.debug("spring interceptor initialized");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (DISABLED || !SPRING_COUNTER.isDisplayed()) {
            return invocation.proceed();
        }
        String requestName = this.getRequestName(invocation);
        boolean systemError = false;
        try {
            SPRING_COUNTER.bindContextIncludingCpu(requestName);
            Object object = invocation.proceed();
            return object;
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            SPRING_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    protected String getRequestName(MethodInvocation invocation) {
        String classPart = MonitoringSpringInterceptor.getClassPart(invocation);
        String methodPart = MonitoringSpringInterceptor.getMethodPart(invocation);
        return classPart + '.' + methodPart;
    }

    private static String getClassPart(MethodInvocation invocation) {
        Class targetClass = AopUtils.getTargetClass((Object)invocation.getThis());
        MonitoredWithSpring classAnnotation = targetClass.getAnnotation(MonitoredWithSpring.class);
        if (classAnnotation == null || classAnnotation.name() == null || classAnnotation.name().isEmpty()) {
            Class<?> declaringClass = invocation.getMethod().getDeclaringClass();
            MonitoredWithSpring declaringClassAnnotation = declaringClass.getAnnotation(MonitoredWithSpring.class);
            if (declaringClassAnnotation == null || declaringClassAnnotation.name() == null || declaringClassAnnotation.name().isEmpty()) {
                return targetClass.getSimpleName();
            }
            return declaringClassAnnotation.name();
        }
        return classAnnotation.name();
    }

    private static String getMethodPart(MethodInvocation invocation) {
        MonitoredWithSpring methodAnnotation = invocation.getMethod().getAnnotation(MonitoredWithSpring.class);
        if (methodAnnotation == null || methodAnnotation.name() == null || methodAnnotation.name().isEmpty()) {
            return invocation.getMethod().getName();
        }
        return methodAnnotation.name();
    }
}

