/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringTokenizer;
import net.bull.javamelody.internal.common.InputOutput;

public final class PID {
    private PID() {
    }

    public static String getPID() {
        String pid = System.getProperty("pid");
        if (pid == null) {
            RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
            String processName = rtb.getName();
            pid = processName.indexOf(64) != -1 ? processName.substring(0, processName.indexOf(64)) : PID.getPIDFromOS();
            System.setProperty("pid", pid);
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getPIDFromOS() {
        String pid;
        File tempFile = null;
        Process process = null;
        try {
            try {
                String[] cmd;
                if (!System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows")) {
                    cmd = new String[]{"/bin/sh", "-c", "echo $$ $PPID"};
                } else {
                    tempFile = File.createTempFile("getpids", ".exe");
                    PID.extractGetPid(tempFile);
                    cmd = new String[]{tempFile.getAbsolutePath()};
                }
                process = Runtime.getRuntime().exec(cmd);
                String processOutput = InputOutput.pumpToString(process.getInputStream(), Charset.defaultCharset());
                StringTokenizer stok = new StringTokenizer(processOutput);
                stok.nextToken();
                pid = stok.nextToken();
                process.waitFor();
            }
            finally {
                if (process != null) {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                    process.destroy();
                }
                if (tempFile != null && !tempFile.delete()) {
                    tempFile.deleteOnExit();
                }
            }
        }
        catch (IOException | InterruptedException e) {
            pid = e.toString();
        }
        return pid;
    }

    private static void extractGetPid(File tempFile) throws IOException {
        try (InputStream input = PID.class.getResourceAsStream("/net/bull/javamelody/resource/getpids.exe");){
            InputOutput.pumpToFile(input, tempFile);
        }
    }
}

