/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.JRobin;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.Range;

public final class UpdateChecker {
    static final String COLLECTOR_SERVER_APPLICATION_TYPE = "Collector server";
    private static final char SEPARATOR = '|';
    private static final String SERVER_URL = "http://javamelody.org/usage/stats";
    private static String newJavamelodyVersion;
    private final Collector collector;
    private final String applicationType;
    private final String serverUrl;

    private UpdateChecker(Collector collector, String applicationType, String serverUrl) {
        assert (applicationType != null);
        assert (collector != null || COLLECTOR_SERVER_APPLICATION_TYPE.equals(applicationType));
        this.collector = collector;
        this.applicationType = applicationType;
        this.serverUrl = serverUrl;
    }

    public static void init(Timer timer, Collector collector, String applicationType) {
        if (!Parameter.UPDATE_CHECK_DISABLED.getValueAsBoolean()) {
            final UpdateChecker updateChecker = new UpdateChecker(collector, applicationType, SERVER_URL);
            TimerTask updateCheckerTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        updateChecker.checkForUpdate();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            timer.scheduleAtFixedRate(updateCheckerTimerTask, 600000L, 86400000L);
        }
    }

    static UpdateChecker createForTest(Collector collector, String applicationType, String serverUrl) {
        return new UpdateChecker(collector, applicationType, serverUrl);
    }

    public static String getNewJavamelodyVersion() {
        return newJavamelodyVersion;
    }

    private static void setNewJavamelodyVersion(String javamelodyVersion) {
        newJavamelodyVersion = javamelodyVersion;
    }

    void checkForUpdate() throws IOException {
        String anonymousData = this.getAnonymousData();
        HttpURLConnection connection = (HttpURLConnection)new URL(this.serverUrl).openConnection();
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(60000);
        connection.setReadTimeout(60000);
        connection.setRequestProperty("data", anonymousData);
        connection.connect();
        Properties properties = new Properties();
        try (InputStream input = connection.getInputStream();){
            properties.load(input);
        }
        String javamelodyVersion = properties.getProperty("version");
        if (javamelodyVersion != null && Parameters.JAVAMELODY_VERSION != null && javamelodyVersion.compareTo(Parameters.JAVAMELODY_VERSION) > 0) {
            UpdateChecker.setNewJavamelodyVersion(javamelodyVersion);
        }
    }

    private String getAnonymousData() throws IOException {
        JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
        String uniqueId = UpdateChecker.hash(Parameters.getHostAddress() + '_' + javaInformations.getContextPath());
        String javamelodyVersion = Parameters.JAVAMELODY_VERSION;
        String serverInfo = javaInformations.getServerInfo();
        String javaVersion = javaInformations.getJavaVersion();
        String jvmVersion = javaInformations.getJvmVersion();
        String maxMemory = String.valueOf(javaInformations.getMemoryInformations().getMaxMemory() / 1024L / 1024L);
        String availableProcessors = String.valueOf(javaInformations.getAvailableProcessors());
        String os = javaInformations.getOS();
        String databases = this.getDatabasesUsed();
        String countersUsed = this.getCountersUsed();
        String parametersUsed = this.getParametersUsed();
        String featuresUsed = this.getFeaturesUsed(javaInformations);
        String locale = Locale.getDefault().toString();
        long usersMean = this.getUsersMean();
        int collectorApplications = COLLECTOR_SERVER_APPLICATION_TYPE.equals(this.applicationType) ? Parameters.getCollectorUrlsByApplications().size() : -1;
        return "{uniqueId=" + UpdateChecker.encode(uniqueId) + ", serverInfo=" + UpdateChecker.encode(serverInfo) + ", javamelodyVersion=" + UpdateChecker.encode(javamelodyVersion) + ", applicationType=" + UpdateChecker.encode(this.applicationType) + ", javaVersion=" + UpdateChecker.encode(javaVersion) + ", jvmVersion=" + UpdateChecker.encode(jvmVersion) + ", maxMemory=" + UpdateChecker.encode(maxMemory) + ", availableProcessors=" + UpdateChecker.encode(availableProcessors) + ", os=" + UpdateChecker.encode(os) + ", databases=" + UpdateChecker.encode(databases) + ", countersUsed=" + UpdateChecker.encode(countersUsed) + ", parametersUsed=" + UpdateChecker.encode(parametersUsed) + ", featuresUsed=" + UpdateChecker.encode(featuresUsed) + ", locale=" + UpdateChecker.encode(locale) + ", usersMean=" + usersMean + ", collectorApplications=" + collectorApplications + '}';
    }

    private long getUsersMean() throws IOException {
        JRobin httpSessionsJRobin;
        if (this.collector != null && (httpSessionsJRobin = this.collector.getJRobin("httpSessions")) != null) {
            double usersMean = httpSessionsJRobin.getMeanValue(this.getYesterdayRange());
            return Math.round(usersMean);
        }
        return 0L;
    }

    private Range getYesterdayRange() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date endDate = calendar.getTime();
        calendar.add(6, -1);
        Date startDate = calendar.getTime();
        return Range.createCustomRange(startDate, endDate);
    }

    private String getParametersUsed() {
        StringBuilder sb = new StringBuilder();
        for (Parameter parameter : Parameter.values()) {
            String value = parameter.getValue();
            if (value == null) continue;
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append(parameter.getCode());
        }
        return sb.toString();
    }

    private String getCountersUsed() {
        if (this.collector == null) {
            return "";
        }
        try {
            List<Counter> counters = this.collector.getRangeCountersToBeDisplayed(Period.TOUT.getRange());
            StringBuilder sb = new StringBuilder();
            for (Counter counter : counters) {
                if (sb.length() != 0) {
                    sb.append('|');
                }
                sb.append(counter.getName());
            }
            return sb.toString();
        }
        catch (IOException e) {
            return e.getClass().getSimpleName();
        }
    }

    private String getFeaturesUsed(JavaInformations javaInformations) {
        ArrayList<String> features = new ArrayList<String>();
        if (Parameters.isPdfEnabled()) {
            features.add("pdf");
        }
        if (javaInformations.isCacheEnabled()) {
            features.add("caches");
        }
        if (javaInformations.isJobEnabled()) {
            features.add("jobs");
        }
        if (features.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : features) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private String getDatabasesUsed() {
        if (Parameters.isNoDatabase()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try {
            if (Parameters.getLastConnectUrl() != null) {
                Connection connection = DriverManager.getConnection(Parameters.getLastConnectUrl(), Parameters.getLastConnectInfo());
                connection.setAutoCommit(false);
                return this.getDatabaseInfo(connection);
            }
            Map<String, DataSource> dataSources = JdbcWrapper.getJndiAndSpringDataSources();
            for (DataSource dataSource : dataSources.values()) {
                Connection connection = dataSource.getConnection();
                if (result.length() > 0) {
                    result.append('|');
                }
                result.append(this.getDatabaseInfo(connection));
            }
        }
        catch (Exception e) {
            result.append(e);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseInfo(Connection connection) throws SQLException {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String string = metaData.getDatabaseProductName() + ' ' + metaData.getDatabaseProductVersion();
            return string;
        }
        finally {
            connection.close();
        }
    }

    private static String encode(String s) {
        if (s != null) {
            return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"").replace('\n', ' ').replace('\r', ' ') + "\"";
        }
        return null;
    }

    private static MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String hash(String value) {
        MessageDigest messageDigest = UpdateChecker.getMessageDigestInstance();
        messageDigest.update(value.getBytes());
        byte[] digest = messageDigest.digest();
        StringBuilder sb = new StringBuilder(digest.length * 2);
        for (int n : digest) {
            int j;
            int n2 = j = n < 0 ? 256 + n : n;
            if (j < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(j));
        }
        return sb.toString();
    }
}

