/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Paint;
import org.jrobin.core.RrdException;
import org.jrobin.data.DataProcessor;
import org.jrobin.graph.Area;
import org.jrobin.graph.Line;
import org.jrobin.graph.SourcedPlotElement;

class Stack
extends SourcedPlotElement {
    private final SourcedPlotElement parent;

    Stack(SourcedPlotElement parent, String srcName, Paint color) {
        super(srcName, color);
        this.parent = parent;
    }

    void assignValues(DataProcessor dproc) throws RrdException {
        double[] parentValues = this.parent.getValues();
        double[] procValues = dproc.getValues(this.srcName);
        this.values = new double[procValues.length];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = parentValues[i] + procValues[i];
            ++i;
        }
    }

    float getParentLineWidth() {
        if (this.parent instanceof Line) {
            return ((Line)this.parent).width;
        }
        if (this.parent instanceof Area) {
            return -1.0f;
        }
        return ((Stack)this.parent).getParentLineWidth();
    }

    Paint getParentColor() {
        return this.parent.color;
    }
}

