/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.JobInformations;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.impl.matchers.GroupMatcher;

public final class QuartzAdapter {
    private static final QuartzAdapter SINGLETON = new QuartzAdapter();

    private QuartzAdapter() {
    }

    public static QuartzAdapter getSingleton() {
        return SINGLETON;
    }

    String getJobName(JobDetail jobDetail) {
        return jobDetail.getKey().getName();
    }

    String getJobGroup(JobDetail jobDetail) {
        return jobDetail.getKey().getGroup();
    }

    public String getJobFullName(JobDetail jobDetail) {
        return this.getJobGroup(jobDetail) + '.' + this.getJobName(jobDetail);
    }

    String getJobDescription(JobDetail jobDetail) {
        return jobDetail.getDescription();
    }

    Class<?> getJobClass(JobDetail jobDetail) {
        return jobDetail.getJobClass();
    }

    Date getTriggerPreviousFireTime(Trigger trigger) {
        return trigger.getPreviousFireTime();
    }

    Date getTriggerNextFireTime(Trigger trigger) {
        return trigger.getNextFireTime();
    }

    String getCronTriggerExpression(CronTrigger trigger) {
        return trigger.getCronExpression();
    }

    long getSimpleTriggerRepeatInterval(SimpleTrigger trigger) {
        return trigger.getRepeatInterval();
    }

    public JobDetail getContextJobDetail(JobExecutionContext context) {
        return context.getJobDetail();
    }

    Date getContextFireTime(JobExecutionContext context) {
        return context.getFireTime();
    }

    public void addGlobalJobListener(JobListener jobGlobalListener) throws SchedulerException {
        Scheduler defaultScheduler;
        ArrayList<EverythingMatcher> allJobs = new ArrayList<EverythingMatcher>();
        allJobs.add(EverythingMatcher.allJobs());
        if (Parameter.QUARTZ_DEFAULT_LISTENER_DISABLED.getValueAsBoolean()) {
            defaultScheduler = null;
            LOG.debug("Initialization of Quartz default listener has been disabled");
        } else {
            defaultScheduler = StdSchedulerFactory.getDefaultScheduler();
            defaultScheduler.getListenerManager().addJobListener(jobGlobalListener, allJobs);
        }
        for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
            if (scheduler == defaultScheduler) continue;
            scheduler.getListenerManager().addJobListener(jobGlobalListener, allJobs);
        }
    }

    public void removeGlobalJobListener(Class<? extends JobListener> jobListenerClass) throws SchedulerException {
        for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
            ListenerManager listenerManager = scheduler.getListenerManager();
            List globalJobListeners = listenerManager.getJobListeners();
            for (JobListener jobListener : new ArrayList(globalJobListeners)) {
                if (!jobListenerClass.isInstance(jobListener)) continue;
                listenerManager.removeJobListener(jobListener.getName());
            }
        }
    }

    List<JobDetail> getAllJobsOfScheduler(Scheduler scheduler) throws SchedulerException {
        ArrayList<JobDetail> result = new ArrayList<JobDetail>();
        for (String jobGroupName : scheduler.getJobGroupNames()) {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)jobGroupName);
            for (JobKey jobKey : scheduler.getJobKeys(groupMatcher)) {
                try {
                    JobDetail jobDetail = scheduler.getJobDetail(jobKey);
                    if (jobDetail == null) continue;
                    result.add(jobDetail);
                }
                catch (Exception e) {
                    LOG.debug(e.toString(), e);
                }
            }
        }
        return result;
    }

    List<Trigger> getTriggersOfJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        return scheduler.getTriggersOfJob(jobDetail.getKey());
    }

    boolean isTriggerPaused(Trigger trigger, Scheduler scheduler) throws SchedulerException {
        return scheduler.getTriggerState(trigger.getKey()) == Trigger.TriggerState.PAUSED;
    }

    void pauseJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        scheduler.pauseJob(jobDetail.getKey());
    }

    void resumeJob(JobDetail jobDetail, Scheduler scheduler) throws SchedulerException {
        scheduler.resumeJob(jobDetail.getKey());
    }
}

